/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.actuator;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import com.sap.cds.feature.mt.MtUtils;
import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.runtime.CdsRuntime;

/**
 * This health check is not configured if MT is inactive (runtime conditions are not met)
 * or db health check is deactivated by profile.
 */
class DbHealthCheckMtCondition implements Condition {

	@Override
	public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
		CdsRuntime runtime = BootstrapCache.get(context.getEnvironment()).getCdsRuntime();
		return runtime.getEnvironment().getCdsProperties().getMultiTenancy().getHealthCheck().isEnabled() &&
				new MtUtils(runtime).mtEnabled(); // mt is enabled generally
	}

}
