package com.sap.cds.framework.spring.config.runtime;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.springframework.core.env.Environment;

import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

/**
 * Caches the {@link CdsRuntimeConfigurer} during initialization of the Spring Boot Application Context.
 */
public class BootstrapCache {

	private static final Map<Environment, CdsRuntimeConfigurer> cache = Collections.synchronizedMap(new HashMap<>());

	public static CdsRuntimeConfigurer get(Environment environment) {
		return cache.computeIfAbsent(environment, (e) -> initialize(e));
	}

	public static void clear(Environment environment) {
		cache.remove(environment);
	}

	private static CdsRuntimeConfigurer initialize(Environment environment) {
		return CdsRuntimeConfigurer.create(new SpringPropertiesProvider(environment))
				.environmentConfigurations()
				.cdsModel();
	}

}
