package com.sap.cds.framework.spring.mt;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.sap.cds.feature.mt.MtUtils;
import com.sap.cds.services.runtime.CdsRuntime;

@Configuration
@ConditionalOnClass(MtUtils.class) // optionally loaded with cds-feature-mt
@AutoConfigureBefore(DefaultMtFeatureConfig.class)
public class LoadedMtFeatureConfig {

	@Bean
	public MtFeature mtFeature(CdsRuntime runtime) {
		MtUtils mtUtils = new MtUtils(runtime);
		return () -> mtUtils.mtEnabled();
	}

}
