/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.datasource;

import com.sap.cds.services.datasource.DataSourceDescriptor;
import com.sap.cds.services.utils.datasource.DataSourceUtils;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.core.env.Environment;

public class DataSourceBeanFactory
implements FactoryBean<DataSource> {
    private final DataSourceDescriptor descriptor;
    private final Environment environment;
    private DataSource dataSource;

    public DataSourceBeanFactory(DataSourceDescriptor descriptor, Environment environment) {
        this.descriptor = descriptor;
        this.environment = environment;
    }

    public DataSource getObject() throws Exception {
        if (this.dataSource == null) {
            DataSourceBuilder builder = DataSourceBuilder.create();
            builder.driverClassName(this.descriptor.getDriverClassName());
            builder.url(this.descriptor.getUrl());
            builder.username(this.descriptor.getUsername());
            builder.password(this.descriptor.getPassword());
            DataSource ds = builder.build();
            Binder binder = Binder.get((Environment)this.environment);
            Bindable bindableDs = Bindable.ofInstance((Object)ds);
            for (String section : DataSourceBeanFactory.getDataSourceSections(this.descriptor.getName())) {
                BindResult bindResult = binder.bind(section, bindableDs);
                if (!bindResult.isBound()) continue;
                ds = (DataSource)bindResult.get();
                break;
            }
            this.dataSource = ds;
        }
        return this.dataSource;
    }

    private static List<String> getDataSourceSections(String name) {
        return Arrays.asList(DataSourceUtils.getDataSourceSection((String)name, (DataSourceUtils.PoolType)DataSourceUtils.PoolType.HIKARI), DataSourceUtils.getDataSourceSection((String)name, (DataSourceUtils.PoolType)DataSourceUtils.PoolType.TOMCAT), DataSourceUtils.getDataSourceSection((String)name, (DataSourceUtils.PoolType)DataSourceUtils.PoolType.DBCP2));
    }

    public Class<DataSource> getObjectType() {
        return DataSource.class;
    }
}

