/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.actuator;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.ExtendedServiceLoader;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.info.CdsInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.http.HttpStatus;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;

@Component
@ConditionalOnClass(value={Endpoint.class})
@Endpoint(id="cds", enableByDefault=true)
public class CdsActuatorEndpoint {
    @Value(value="#{'${management.endpoint.cds.details:MEDIUM}'.toUpperCase()}")
    private CdsInfo.Details defaultDetails;
    private final List<CdsInfo> cdsInfoList = new ArrayList<CdsInfo>();

    @Autowired
    public CdsActuatorEndpoint(CdsRuntime runtime) {
        ExtendedServiceLoader.loadAll(CdsInfo.class, (CdsRuntime)runtime).forEachRemaining(this.cdsInfoList::add);
    }

    @ReadOperation
    public Map<String, Object> info(@RequestParam @Nullable String details) {
        return this.createCdsInfo(i -> true, this.gainDetails(details));
    }

    @ReadOperation
    public Map<String, Object> infoEntry(@Selector String info, @RequestParam @Nullable String details) {
        return this.createCdsInfo(i -> i.name().equalsIgnoreCase(info), this.gainDetails(details));
    }

    private CdsInfo.Details gainDetails(String details) {
        if (!StringUtils.isEmpty((String)details)) {
            try {
                return CdsInfo.Details.valueOf((String)details.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception e) {
                throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "Invalid detail parameter '" + details + "'");
            }
        }
        return this.defaultDetails;
    }

    private Map<String, Object> createCdsInfo(Predicate<CdsInfo> filter, CdsInfo.Details details) {
        LinkedHashMap<String, Object> cdsInfo = new LinkedHashMap<String, Object>();
        this.cdsInfoList.stream().filter(filter).forEach(section -> cdsInfo.put(section.name(), section.info(details)));
        return cdsInfo;
    }
}

