/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.actuator;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.mt.runtime.DbHealthIndicatorImpl;
import com.sap.cloud.mt.runtime.TenantAwareDataSource;
import javax.sql.DataSource;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.jdbc.DataSourceHealthIndicator;

public class DbHealthIndicatorMt
implements HealthIndicator {
    private DbHealthIndicatorImpl<Health> dbHealthIndicatorMt;
    private DataSourceHealthIndicator dbHealthIndicatorSt;

    public DbHealthIndicatorMt(DataSource dataSource, CdsRuntime runtime) {
        long intervallMillis = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getHealthCheck().getIntervalMillis();
        String healthCheckStatement = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getHealthCheck().getHealthCheckStatement();
        if (dataSource instanceof TenantAwareDataSource) {
            this.dbHealthIndicatorMt = new DbHealthIndicatorImpl(healthCheckStatement, (TenantAwareDataSource)dataSource, Long.valueOf(intervallMillis), () -> Health.up().build(), (text, details) -> Health.down().withDetail(text, (Object)details).build(), (text, details) -> Health.up().withDetail(text, (Object)details).build());
        } else {
            this.dbHealthIndicatorSt = new DataSourceHealthIndicator(dataSource);
        }
    }

    public Health health() {
        if (this.dbHealthIndicatorMt != null) {
            return (Health)this.dbHealthIndicatorMt.health();
        }
        return this.dbHealthIndicatorSt.health();
    }
}

