/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.adapter;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.framework.spring.config.adapter.ServletAdapterRestController;
import javax.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartFactoryBean;

public class AdapterBeanFactory
implements SmartFactoryBean<Object> {
    private static final Logger logger = LoggerFactory.getLogger(AdapterBeanFactory.class);
    private final AdapterFactory factory;
    private Object adapter;

    public AdapterBeanFactory(AdapterFactory factory) {
        this.factory = factory;
    }

    public Object getObject() throws Exception {
        if (this.adapter == null) {
            if (this.factory instanceof ServletAdapterFactory) {
                ServletAdapterFactory servletFactory = (ServletAdapterFactory)this.factory;
                Servlet servlet = servletFactory.create();
                String servletName = servlet.getClass().getSimpleName();
                String basePath = servletFactory.getBasePath();
                this.adapter = new ServletAdapterRestController(servlet, basePath);
                logger.info("Servlet {} mapped to {}", (Object)servletName, (Object)basePath);
            } else {
                this.adapter = this.factory.create();
                logger.info("Adapter {} initialized", (Object)this.adapter.getClass().getSimpleName());
            }
        }
        return this.adapter;
    }

    public Class<?> getObjectType() {
        return Object.class;
    }

    public boolean isEagerInit() {
        return true;
    }
}

