/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth.xsuaa;

import com.sap.cds.framework.spring.config.auth.HttpSecurityConfigurer;
import com.sap.cds.framework.spring.config.auth.identity.IdentitySecurityConfig;
import com.sap.cds.framework.spring.config.auth.xsuaa.XsuaaConfiguredCondition;
import com.sap.cds.framework.spring.config.auth.xsuaa.XsuaaFeature;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.XsuaaUtils;
import com.sap.cloud.security.config.OAuth2ServiceConfiguration;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.client.OAuth2TokenService;
import com.sap.cloud.security.xsuaa.client.XsuaaOAuth2TokenService;
import com.sap.cloud.security.xsuaa.extractor.IasXsuaaExchangeBroker;
import com.sap.cloud.security.xsuaa.token.TokenAuthenticationConverter;
import com.sap.cloud.security.xsuaa.tokenflows.TokenCacheConfiguration;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.web.client.RestOperations;

@Configuration
@ConditionalOnClass(value={XsuaaServiceConfiguration.class, WebSecurityConfigurer.class, Jwt.class})
@Conditional(value={XsuaaConfiguredCondition.class})
@AutoConfigureAfter(value={IdentitySecurityConfig.class})
@ConditionalOnMissingBean(value={IdentitySecurityConfig.class})
@EnableWebSecurity
@Order(value=1000)
public class XsuaaSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(XsuaaSecurityConfig.class);
    @Autowired
    private CdsRuntime runtime;
    @Autowired
    private XsuaaServiceConfiguration xsuaaServiceConfiguration;
    @Autowired
    private HttpSecurityConfigurer httpSecurityConfigurer;
    @Autowired
    private XsuaaFeature xsuaaFeatue;
    @Autowired
    private RestOperations xsuaaRestOperations;

    protected void configure(HttpSecurity http) throws Exception {
        if (!this.xsuaaFeatue.isActive()) {
            throw new IllegalStateException("XSUAA configuration requires dependency to cds-feature-xsuaa. Alternatively, deactivate this security configuration with property 'cds.security.xsuaa.enabled: false' AND provide your own configuration.");
        }
        XsuaaUtils.AuthenticationType authType = new XsuaaUtils(this.runtime).configuredAuthenticationType();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        this.httpSecurityConfigurer.configure(http);
        OAuth2ResourceServerConfigurer resourceServer = http.oauth2ResourceServer();
        if (authType == XsuaaUtils.AuthenticationType.IAS_XSUAA) {
            TokenCacheConfiguration tokenCacheConfiguration = TokenCacheConfiguration.cacheDisabled();
            CdsProperties.Security.Xsuaa.Cache cache = this.runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().getCache();
            if (cache.isEnabled().booleanValue()) {
                tokenCacheConfiguration = TokenCacheConfiguration.getInstance((Duration)cache.getDuration(), (int)cache.getSize(), (Duration)cache.getTokenRemainingTime(), (boolean)false);
            }
            XsuaaOAuth2TokenService oAuth2TokenService = new XsuaaOAuth2TokenService(this.xsuaaRestOperations, tokenCacheConfiguration);
            resourceServer.bearerTokenResolver((BearerTokenResolver)new IasXsuaaExchangeBroker((OAuth2ServiceConfiguration)this.xsuaaServiceConfiguration, (OAuth2TokenService)oAuth2TokenService));
        }
        resourceServer.jwt().jwtAuthenticationConverter(this.getJwtAuthoritiesConverter());
        switch (authType) {
            case XSUAA: {
                logger.info("Activated XSUAA security configuration");
                break;
            }
            case IAS_XSUAA: {
                logger.info("Activated XSUAA security configuration with IAS support");
                break;
            }
            default: {
                throw new IllegalStateException("Configuration error: Can't configure authentication without a binding to XSUAA service");
            }
        }
    }

    private Converter<Jwt, AbstractAuthenticationToken> getJwtAuthoritiesConverter() {
        TokenAuthenticationConverter converter = new TokenAuthenticationConverter(this.xsuaaServiceConfiguration);
        converter.setLocalScopeAsAuthorities(true);
        return converter;
    }
}

