/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.transaction;

import com.sap.cds.framework.spring.transaction.SpringTransactionManager;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.changeset.ChangeSetContextSPI;
import com.sap.cds.services.changeset.ChangeSetMember;
import com.sap.cds.services.impl.changeset.ChangeSetContextImpl;
import com.sap.cds.services.transaction.ChangeSetMemberDelegate;
import com.sap.cds.services.transaction.TransactionManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Component
@ConditionalOnClass(value={PlatformTransactionManager.class})
public class PlatformTransactionManagerPostProcessor
implements BeanPostProcessor {
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Object proxiedBean = bean;
        if (bean instanceof PlatformTransactionManager) {
            Class<?> clazz = bean.getClass();
            HashSet interfaces = new HashSet();
            do {
                interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
            } while (!(clazz = clazz.getSuperclass()).equals(Object.class));
            interfaces.add(SpringTransactionManagerGetter.class);
            PTMInvocationHandler handler = new PTMInvocationHandler((PlatformTransactionManager)bean);
            proxiedBean = Proxy.newProxyInstance(bean.getClass().getClassLoader(), interfaces.toArray(new Class[0]), (InvocationHandler)handler);
        }
        return proxiedBean;
    }

    private static class PTMInvocationHandler
    implements InvocationHandler {
        private final PlatformTransactionManager platformTxMgr;
        private final SpringTransactionManager txMgr;
        private boolean proxyEnabled = false;

        public PTMInvocationHandler(PlatformTransactionManager platformTxMgr) {
            this.platformTxMgr = platformTxMgr;
            this.txMgr = new SpringTransactionManager(platformTxMgr);
        }

        @Override
        public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
            if (this.proxyEnabled && method.getName().equals("getTransaction") && args.length == 1 && args[0] instanceof TransactionDefinition) {
                TransactionDefinition txDefinition = (TransactionDefinition)args[0];
                ChangeSetContextSPI currentChangeSet = (ChangeSetContextSPI)ChangeSetContext.getCurrent();
                if (txDefinition.getPropagationBehavior() == 0 && currentChangeSet != null && !currentChangeSet.hasChangeSetMember(this.txMgr.getName())) {
                    currentChangeSet.register((ChangeSetMember)new ChangeSetMemberDelegate((TransactionManager)this.txMgr));
                    this.txMgr.begin();
                } else if (txDefinition.getPropagationBehavior() == 0 && currentChangeSet == null || txDefinition.getPropagationBehavior() == 3) {
                    ChangeSetContextImpl newChangeSetContext = ChangeSetContextImpl.attach();
                    newChangeSetContext.register((ChangeSetMember)new ChangeSetMemberDelegate((TransactionManager)this.txMgr));
                    SpringTransactionSynchronization sync = new SpringTransactionSynchronization(newChangeSetContext);
                    try {
                        TransactionStatus txStatus = (TransactionStatus)method.invoke((Object)this.platformTxMgr, args);
                        sync.setTransactionStatus(txStatus);
                        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)sync);
                        return txStatus;
                    }
                    catch (Exception e) {
                        newChangeSetContext.close();
                        throw e;
                    }
                }
            } else {
                if (method.getName().equals("getSpringTransactionManager") && args == null) {
                    this.proxyEnabled = true;
                    return this.txMgr;
                }
                if (method.getName().equals("getPlatformTransactionManager") && args == null) {
                    return this.platformTxMgr;
                }
            }
            return method.invoke((Object)this.platformTxMgr, args);
        }
    }

    private static class SpringTransactionSynchronization
    implements TransactionSynchronization {
        private final ChangeSetContextImpl changeSetContext;
        private TransactionStatus txStatus;

        public SpringTransactionSynchronization(ChangeSetContextImpl changeSetContext) {
            this.changeSetContext = changeSetContext;
        }

        public void setTransactionStatus(TransactionStatus txStatus) {
            this.txStatus = txStatus;
        }

        public void beforeCompletion() {
            try {
                this.changeSetContext.triggerBeforeClose();
            }
            finally {
                if (this.changeSetContext.isMarkedForCancel() && this.txStatus != null) {
                    this.txStatus.setRollbackOnly();
                }
            }
        }

        public void afterCompletion(int status) {
            if (status != 0) {
                this.changeSetContext.markForCancel();
            }
            this.changeSetContext.close();
        }
    }

    public static interface SpringTransactionManagerGetter {
        public SpringTransactionManager getSpringTransactionManager();

        public PlatformTransactionManager getPlatformTransactionManager();
    }
}

