package com.sap.cds.framework.spring.config.auth.identity;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.sap.cds.feature.identity.IdentityUserInfoProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.XsuaaUtils;

@Configuration
@ConditionalOnClass(IdentityUserInfoProvider.class) // optionally loaded with cds-feature-identity
@AutoConfigureBefore(DefaultIdentityFeatureConfig.class)
public class LoadedIdentityFeatureConfig {

	@Bean
	public IdentityFeature identityFeature(CdsRuntime runtime) {
		XsuaaUtils xsuaaUtils = new XsuaaUtils(runtime);	
		return () -> xsuaaUtils.identityAuthenticationConfigured();
	}

}
