/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth.xsuaa;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.sap.cds.feature.xsuaa.XsuaaUserInfo;
import com.sap.cds.framework.spring.utils.ProxyUtils;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;

@Configuration
@ConditionalOnClass(XsuaaUserInfo.class)
public class XsuaaUserInfoConfig {

	@Bean
	public XsuaaUserInfo xsuaaUserInfo(CdsRuntime runtime) {
		return ProxyUtils.createProxy(XsuaaUserInfo.class, () -> RequestContext.getCurrent(runtime).getUserInfo().as(XsuaaUserInfo.class));
	}

}
