/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth.identity;

import com.sap.cds.framework.spring.config.auth.HttpSecurityConfigurer;
import com.sap.cds.framework.spring.config.auth.identity.IdentityConfiguredCondition;
import com.sap.cds.framework.spring.config.auth.identity.IdentityFeature;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.XsuaaUtils;
import com.sap.cloud.security.spring.config.IdentityServiceConfiguration;
import com.sap.cloud.security.spring.config.IdentityServicesPropertySourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.oauth2.server.resource.OAuth2ResourceServerConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.jwt.Jwt;

@Configuration
@ConditionalOnClass(value={IdentityServiceConfiguration.class, WebSecurityConfigurer.class, Jwt.class})
@Conditional(value={IdentityConfiguredCondition.class})
@PropertySource(factory=IdentityServicesPropertySourceFactory.class, value={""})
@EnableWebSecurity
@Order(value=1000)
public class IdentitySecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(IdentitySecurityConfig.class);
    @Autowired
    private CdsRuntime runtime;
    @Autowired
    private HttpSecurityConfigurer httpSecurityConfigurer;
    @Autowired
    private IdentityFeature identityFeatue;
    @Autowired(required=false)
    private Converter<Jwt, AbstractAuthenticationToken> authConverter;

    protected void configure(HttpSecurity http) throws Exception {
        if (!this.identityFeatue.isActive()) {
            throw new IllegalStateException("Identity configuration requires dependency to cds-feature-identity. Alternatively, deactivate this security configuration with property 'cds.security.identity.enabled: false' AND provide your own configuration.");
        }
        XsuaaUtils.AuthenticationType authType = new XsuaaUtils(this.runtime).configuredAuthenticationType();
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        this.httpSecurityConfigurer.configure(http);
        OAuth2ResourceServerConfigurer.JwtConfigurer jwtConfigurer = http.oauth2ResourceServer().jwt();
        if (this.authConverter != null) {
            jwtConfigurer.jwtAuthenticationConverter(this.authConverter);
        }
        switch (authType) {
            case XSUAA: {
                if (this.authConverter == null) {
                    throw new IllegalStateException("Identity configuration for XSUAA requires Converter<Jwt, AbstractAuthenticationToken>");
                }
                logger.info("Activated identity security configuration based on XSUAA");
                break;
            }
            case IAS: {
                logger.info("Activated identity security configuration based on IAS");
                break;
            }
            default: {
                throw new IllegalStateException("Configuration error: Can't configure authentication without a unique binding to either XSUAA or IAS service");
            }
        }
    }
}

