/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.framework.spring.config.adapter.AdapterBeanFactory;
import com.sap.cds.framework.spring.config.datasource.DataSourceBeanFactory;
import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.datasource.DataSourceDescriptor;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.runtime.ExtendedServiceLoader;
import com.sap.cds.services.utils.datasource.DataSourceUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;

@Configuration
public class CdsRuntimeConfig
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(CdsRuntimeConfig.class);
    private static boolean springWebAvailable;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        CdsRuntimeConfigurer configurer = BootstrapCache.get(this.environment).serviceConfigurations();
        BeanDefinitionBuilder configurerBuilder = BeanDefinitionBuilder.genericBeanDefinition(CdsRuntimeConfigurer.class, () -> configurer);
        registry.registerBeanDefinition("cdsRuntimeConfigurer", (BeanDefinition)configurerBuilder.getBeanDefinition());
        CdsRuntime runtime = configurer.getCdsRuntime();
        BeanDefinitionBuilder runtimeBuilder = BeanDefinitionBuilder.genericBeanDefinition(CdsRuntime.class, () -> runtime);
        registry.registerBeanDefinition("cdsRuntime", (BeanDefinition)runtimeBuilder.getBeanDefinition());
        this.registerDataSources(registry, runtime);
        this.registerServices(registry, runtime);
        this.registerAdapters(registry, runtime);
    }

    private void registerDataSources(BeanDefinitionRegistry registry, CdsRuntime runtime) {
        String springDataSourceUrl = this.environment.getProperty("spring.datasource.url");
        if (springDataSourceUrl != null) {
            if (springDataSourceUrl.contains(":sqlite:") && springDataSourceUrl.contains(":memory:")) {
                logger.debug("Determined DataSource as embedded based on 'spring.datasource.url' configuration.");
                runtime.getEnvironment().getCdsProperties().getDataSource().setEmbedded(true);
            }
            logger.info("Found 'spring.datasource.url' configuration: Auto-configuration of DataSource beans is disabled.");
            return;
        }
        if (!runtime.getEnvironment().getCdsProperties().getDataSource().getAutoConfig().isEnabled().booleanValue()) {
            logger.info("Auto-configuration of DataSource beans is explicitly disabled.");
            return;
        }
        List descriptors = DataSourceUtils.getDataSourceDescriptors((CdsRuntime)runtime);
        for (DataSourceDescriptor descriptor : descriptors) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceBeanFactory.class);
            boolean isPrimary = descriptor.getName().equals(runtime.getEnvironment().getCdsProperties().getDataSource().getBinding());
            builder.addConstructorArgValue((Object)descriptor);
            builder.addConstructorArgValue((Object)this.environment);
            builder.setPrimary(isPrimary);
            registry.registerBeanDefinition(descriptor.getName(), (BeanDefinition)builder.getBeanDefinition());
            logger.info("Registered {}DataSource '{}'", (Object)(isPrimary ? "primary " : ""), (Object)descriptor.getName());
        }
        Map dataSources = DataSourceUtils.getDataSources((CdsRuntime)runtime);
        for (Map.Entry entry : dataSources.entrySet()) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(((DataSource)entry.getValue()).getClass(), () -> (DataSource)entry.getValue());
            boolean isPrimary = ((String)entry.getKey()).equals(runtime.getEnvironment().getCdsProperties().getDataSource().getBinding());
            builder.setPrimary(isPrimary);
            registry.registerBeanDefinition((String)entry.getKey(), (BeanDefinition)builder.getBeanDefinition());
            logger.info("Registered {}DataSource '{}'", (Object)(isPrimary ? "primary " : ""), entry.getKey());
        }
    }

    private void registerServices(BeanDefinitionRegistry registry, CdsRuntime runtime) {
        runtime.getServiceCatalog().getServices().forEach(service -> {
            BeanDefinitionBuilder serviceBuilder = BeanDefinitionBuilder.genericBeanDefinition(service.getClass(), () -> service);
            registry.registerBeanDefinition(service.getName(), (BeanDefinition)serviceBuilder.getBeanDefinition());
        });
    }

    private void registerAdapters(BeanDefinitionRegistry registry, CdsRuntime runtime) {
        Iterator factoryIterator = ExtendedServiceLoader.loadAll(AdapterFactory.class, (CdsRuntime)runtime);
        while (factoryIterator.hasNext()) {
            AdapterFactory factory = (AdapterFactory)factoryIterator.next();
            if (factory instanceof ServletAdapterFactory && !springWebAvailable || !factory.isEnabled()) continue;
            String beanName = factory.getClass().getSimpleName();
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AdapterBeanFactory.class);
            builder.addConstructorArgValue((Object)factory);
            registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
            if (!(factory instanceof ServletAdapterFactory)) continue;
            ServletAdapterFactory servletFactory = (ServletAdapterFactory)factory;
            BeanDefinitionBuilder mappingBuilder = BeanDefinitionBuilder.genericBeanDefinition(SimpleUrlHandlerMapping.class, () -> {
                SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
                HashMap<String, String> urlMap = new HashMap<String, String>();
                for (String m : servletFactory.getMappings()) {
                    urlMap.put(m, beanName);
                }
                mapping.setOrder(0x7FFFFFFE);
                mapping.setUrlMap(urlMap);
                return mapping;
            });
            registry.registerBeanDefinition(beanName + "Mapping", (BeanDefinition)mappingBuilder.getBeanDefinition());
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    static {
        try {
            springWebAvailable = SimpleUrlHandlerMapping.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            springWebAvailable = false;
        }
    }
}

