/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.framework.spring.utils.ProxyUtils;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class RequestContextConfig {
    @Bean
    public CdsModel cdsModel(CdsRuntime runtime) {
        return ProxyUtils.createProxy(CdsModel.class, () -> RequestContext.getCurrent((CdsRuntime)runtime).getModel());
    }

    @Bean
    public ServiceCatalog serviceCatalog(CdsRuntime runtime) {
        return ProxyUtils.createProxy(ServiceCatalog.class, () -> RequestContext.getCurrent((CdsRuntime)runtime).getServiceCatalog());
    }

    @Bean
    @Primary
    public UserInfo userInfo(CdsRuntime runtime) {
        return ProxyUtils.createProxy(UserInfo.class, () -> RequestContext.getCurrent((CdsRuntime)runtime).getUserInfo());
    }

    @Bean
    public AuthenticationInfo authenticationInfo(CdsRuntime runtime) {
        return ProxyUtils.createProxy(AuthenticationInfo.class, () -> RequestContext.getCurrent((CdsRuntime)runtime).getAuthenticationInfo());
    }

    @Bean
    public Messages messages(CdsRuntime runtime) {
        return ProxyUtils.createProxy(Messages.class, () -> RequestContext.getCurrent((CdsRuntime)runtime).getMessages());
    }

    @Bean
    public ParameterInfo parameterInfo(CdsRuntime runtime) {
        return ProxyUtils.createProxy(ParameterInfo.class, () -> RequestContext.getCurrent((CdsRuntime)runtime).getParameterInfo());
    }

    @Bean
    public FeatureTogglesInfo featureTogglesInfo(CdsRuntime runtime) {
        return ProxyUtils.createProxy(FeatureTogglesInfo.class, () -> RequestContext.getCurrent((CdsRuntime)runtime).getFeatureTogglesInfo());
    }
}

