/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth.mock;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.framework.spring.config.auth.HttpSecurityConfigurer;
import com.sap.cds.framework.spring.config.auth.identity.IdentitySecurityConfig;
import com.sap.cds.framework.spring.config.auth.mock.MockUsersConfiguredCondition;
import com.sap.cds.framework.spring.config.auth.xsuaa.XsuaaSecurityConfig;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.provisioning.InMemoryUserDetailsManagerConfigurer;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;

@Configuration
@ConditionalOnClass(value={WebSecurityConfigurer.class})
@AutoConfigureAfter(value={XsuaaSecurityConfig.class, IdentitySecurityConfig.class})
@ConditionalOnMissingBean(value={XsuaaSecurityConfig.class, IdentitySecurityConfig.class})
@Conditional(value={MockUsersConfiguredCondition.class})
@EnableWebSecurity
@Order(value=1000)
public class MockUsersSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(MockUsersSecurityConfig.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    @Autowired
    private HttpSecurityConfigurer httpSecurityConfigurer;
    @Autowired
    private CdsRuntime runtime;

    public void configure(AuthenticationManagerBuilder auth) throws Exception {
        List mockUsers = this.runtime.getEnvironment().getCdsProperties().getSecurity().getMock().getUsers();
        if (mockUsers.isEmpty()) {
            logger.warn("No mock users found in configuration. Spring standard authentication manager with default user 'user' (password written to console) is available");
            super.configure(auth);
            return;
        }
        InMemoryUserDetailsManagerConfigurer authConfigurer = auth.inMemoryAuthentication();
        PasswordEncoder encoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
        authConfigurer.passwordEncoder(encoder);
        for (CdsProperties.Security.Mock.User user : mockUsers) {
            if (!user.isValid()) {
                logger.warn("Skipping invalid mock user defintion {} ('name' and 'password' required)", (Object)this.stringifyUser(user));
                continue;
            }
            authConfigurer.withUser(user.getName()).password(encoder.encode((CharSequence)user.getPassword())).authorities(user.getRoles().toArray(new String[0]));
            logger.info("Added mock user {}", (Object)this.stringifyUser(user));
        }
    }

    public void configure(HttpSecurity http) throws Exception {
        http.csrf().disable();
        this.httpSecurityConfigurer.configure(http);
        http.httpBasic();
        logger.info("*************************************************************************");
        logger.info("*  Security configuration based on mock users found in active profile.  *");
        logger.info("*                 !!! NEVER USE IN PRODUCTIVE MODE !!!                  *");
        logger.info("*************************************************************************");
    }

    private String stringifyUser(CdsProperties.Security.Mock.User user) {
        try {
            return mapper.writeValueAsString((Object)user);
        }
        catch (Exception e) {
            return user.getName();
        }
    }

    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

