/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.utils;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.mt.MtUtils;
import com.sap.cds.mtx.impl.Authenticator;
import com.sap.cds.mtx.impl.ClientCredentialJwtAccess;
import com.sap.cds.mtx.impl.ClientCredentialJwtReader;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.mt.MtSubscriptionService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import com.sap.cloud.mt.subscription.json.SidecarUpgradePayload;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;

@SpringBootApplication
public class Deploy {
    private static final Logger log = LoggerFactory.getLogger(Deploy.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String PARAMETER_ALL_TENANTS = "all";

    public static void main(String[] args) throws Exception {
        try {
            System.setProperty("cds.security.xsuaa.enabled", "false");
            System.setProperty("cds.security.mock.enabled", "false");
            System.setProperty("cds.messaging.webhooks.enabled", "false");
            CdsRuntime runtime = (CdsRuntime)new SpringApplicationBuilder(new Class[]{Deploy.class}).web(WebApplicationType.NONE).run(new String[0]).getBean(CdsRuntime.class);
            MtSubscriptionService mtService = (MtSubscriptionService)runtime.getServiceCatalog().getService(MtSubscriptionService.class, "MtSubscriptionService$Default");
            assert (!runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().isEnabled().booleanValue());
            assert (!runtime.getEnvironment().getCdsProperties().getSecurity().getMock().isEnabled().booleanValue());
            assert (!runtime.getEnvironment().getCdsProperties().getMessaging().getWebhooks().isEnabled().booleanValue());
            if (mtService != null) {
                long timestamp = System.currentTimeMillis();
                CharSequence[] tenants = Arrays.copyOf(args, args.length);
                if (tenants.length == 0) {
                    tenants = new String[]{PARAMETER_ALL_TENANTS};
                    log.info("Starting database update for all tenants");
                } else {
                    log.info("Starting database update for tenant(s) {}", (Object)String.join((CharSequence)", ", tenants));
                }
                DeployHelper deployHelper = new DeployHelper(mtService, runtime);
                if (!deployHelper.deploy((String[])tenants)) {
                    Deploy.logErrorMessage();
                    System.exit(3);
                }
                log.info("Database update finished successfully in {}s", (Object)((System.currentTimeMillis() - timestamp) / 1000L));
            } else {
                log.error("Failed: MT Service not found");
                Deploy.logErrorMessage();
                System.exit(2);
            }
        }
        catch (Throwable t) {
            log.error("Unexpected error", t);
            Deploy.logErrorMessage();
            System.exit(1);
        }
        Deploy.logSuccessMessage();
        System.exit(0);
    }

    private static void logSuccessMessage() {
        log.info("*************");
        log.info("*  SUCCESS  *");
        log.info("*************");
    }

    private static void logErrorMessage() {
        log.error("***********");
        log.error("*  ERROR  *");
        log.error("***********");
    }

    public static class DeployHelper {
        private static final String SIDECAR_STATUS_RUNNING = "RUNNING";
        private static final String SIDECAR_DEPLOY_RESULT_SUCCESS = "SUCCESS";
        private final MtSubscriptionService mtService;
        private final CdsRuntime runtime;

        public DeployHelper(MtSubscriptionService mtService, CdsRuntime runtime) {
            this.mtService = mtService;
            this.runtime = runtime;
        }

        public boolean deploy(String[] tenants) {
            SidecarUpgradePayload upgradePayload = new SidecarUpgradePayload();
            upgradePayload.tenants = tenants;
            CdsProperties.MultiTenancy config = this.runtime.getEnvironment().getCdsProperties().getMultiTenancy();
            String deployScope = config.getSecurity().getDeploymentScope();
            return (Boolean)this.runtime.requestContext().clearUser().modifyUser(user -> user.addRole(deployScope).setIsAuthenticated(true)).run(context -> {
                block4: {
                    MtUtils mtUtils = new MtUtils(this.runtime);
                    if (mtUtils.isClassicSidecarEnabled() || mtUtils.isProvisioningServiceEnabled()) {
                        try {
                            ClientCredentialJwtReader jwtReader = new DynamicModelUtils(this.runtime).createClientCredentialJwtReader();
                            Authenticator jwtAccess = jwtReader != null ? new ClientCredentialJwtAccess(jwtReader) : Authenticator.NONE;
                            String jobId = this.startDbDeploymentSidecar(upgradePayload, jwtAccess);
                            SidecarResult sidecarResult = this.waitForDeploymentToFinish(jobId, jwtAccess);
                            boolean deploymentFailed = sidecarResult.result.tenants.values().stream().anyMatch(tenant -> !SIDECAR_DEPLOY_RESULT_SUCCESS.equals(tenant.status));
                            if (sidecarResult.error != null || deploymentFailed) {
                                log.error("Database update failed, last sidecar response:\n{}", (Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)sidecarResult));
                                return false;
                            }
                            break block4;
                        }
                        catch (Throwable t) {
                            throw new RuntimeException(t);
                        }
                    }
                    this.mtService.deploy(upgradePayload);
                }
                return true;
            });
        }

        private String startDbDeploymentSidecar(SidecarUpgradePayload upgradePayload, Authenticator authenticator) throws IOException {
            String jobIdResultStr = this.mtService.asyncDeploy(upgradePayload, (String)authenticator.getAuthorization().orElse(null));
            JobIdResult jobIdResult = (JobIdResult)mapper.readValue(jobIdResultStr, JobIdResult.class);
            return jobIdResult.jobID;
        }

        private SidecarResult waitForDeploymentToFinish(String jobId, Authenticator authenticator) throws InterruptedException, IOException {
            String resultStr;
            SidecarResult sidecarResult;
            String status;
            long lastTimestamp = 0L;
            do {
                Thread.sleep(2000L);
                resultStr = this.mtService.asyncDeployStatus(jobId, (String)authenticator.getAuthorization().orElse(null));
                if (System.currentTimeMillis() - lastTimestamp > 60000L) {
                    log.info("Waiting for database update to finish. Current status: {}", (Object)resultStr);
                    lastTimestamp = System.currentTimeMillis();
                }
                sidecarResult = (SidecarResult)mapper.readValue(resultStr, SidecarResult.class);
            } while (SIDECAR_STATUS_RUNNING.equals(status = sidecarResult.status));
            log.debug("Last sidecar response: {}", (Object)resultStr);
            return sidecarResult;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        private static final class JobIdResult {
            public String jobID;

            private JobIdResult() {
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        private static final class SidecarResult {
            public String error;
            public String status;
            public DeployResult result;

            private SidecarResult() {
            }

            private static final class DeployResult {
                public Map<String, TenantResult> tenants;

                private DeployResult() {
                }

                private static final class TenantResult {
                    public String status;
                    public String message;
                    public String buildLogs;

                    private TenantResult() {
                    }
                }
            }
        }
    }
}

