/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.framework.spring.config.adapter.AdapterBeanFactory;
import com.sap.cds.framework.spring.config.datasource.DataSourceBeanFactory;
import com.sap.cds.framework.spring.config.datasource.DataSourceTransactionManagerBeanFactory;
import com.sap.cds.framework.spring.config.datasource.JdbcPersistenceServiceBeanFactory;
import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.impl.persistence.JdbcPersistenceServiceConfiguration;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.runtime.ExtendedServiceLoader;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.datasource.DataSourceUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;

@AutoConfiguration
public class CdsRuntimeConfig
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(CdsRuntimeConfig.class);
    private static boolean springWebAvailable;
    private static boolean springJdbcAvailable;
    private static boolean cdsJdbcAvailable;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        CdsRuntimeConfigurer configurer = BootstrapCache.get(this.environment).serviceConfigurations();
        BeanDefinitionBuilder configurerBuilder = BeanDefinitionBuilder.genericBeanDefinition(CdsRuntimeConfigurer.class, () -> configurer);
        registry.registerBeanDefinition("cdsRuntimeConfigurer", (BeanDefinition)configurerBuilder.getBeanDefinition());
        CdsRuntime runtime = configurer.getCdsRuntime();
        BeanDefinitionBuilder runtimeBuilder = BeanDefinitionBuilder.genericBeanDefinition(CdsRuntime.class, () -> runtime);
        registry.registerBeanDefinition("cdsRuntime", (BeanDefinition)runtimeBuilder.getBeanDefinition());
        this.registerDataSources(registry, configurer);
        this.registerServices(registry, runtime);
        this.registerAdapters(registry, runtime);
    }

    private void registerDataSources(BeanDefinitionRegistry registry, CdsRuntimeConfigurer configurer) {
        CdsRuntime runtime = configurer.getCdsRuntime();
        String springDataSourceUrl = this.environment.getProperty("spring.datasource.url");
        if (springDataSourceUrl != null) {
            if (springDataSourceUrl.contains(":sqlite:") && springDataSourceUrl.contains(":memory:")) {
                logger.debug("Determined DataSource as embedded based on 'spring.datasource.url' configuration.");
                runtime.getEnvironment().getCdsProperties().getDataSource().setEmbedded(true);
            }
            logger.info("Found 'spring.datasource.url' configuration: Auto-configuration of DataSource beans is disabled.");
            return;
        }
        if (!runtime.getEnvironment().getCdsProperties().getDataSource().getAutoConfig().isEnabled().booleanValue()) {
            logger.info("Auto-configuration of DataSource beans is explicitly disabled.");
            return;
        }
        LinkedHashMap<String, AbstractBeanDefinition> dataSourceBeanDefinitions = new LinkedHashMap<String, AbstractBeanDefinition>();
        List descriptors = DataSourceUtils.getDataSourceDescriptors((CdsRuntime)runtime);
        for (Object descriptor : descriptors) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceBeanFactory.class);
            boolean isPrimary = descriptor.getName().equals(runtime.getEnvironment().getCdsProperties().getDataSource().getBinding());
            beanDefinitionBuilder.addConstructorArgValue(descriptor);
            beanDefinitionBuilder.addConstructorArgValue((Object)this.environment);
            beanDefinitionBuilder.setPrimary(isPrimary);
            dataSourceBeanDefinitions.put(descriptor.getName(), beanDefinitionBuilder.getBeanDefinition());
        }
        Map dataSources = DataSourceUtils.getDataSources((CdsRuntime)runtime);
        for (Map.Entry entry : dataSources.entrySet()) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(((DataSource)entry.getValue()).getClass(), () -> (DataSource)entry.getValue());
            boolean isPrimary = ((String)entry.getKey()).equals(runtime.getEnvironment().getCdsProperties().getDataSource().getBinding());
            builder.setPrimary(isPrimary);
            dataSourceBeanDefinitions.put((String)entry.getKey(), builder.getBeanDefinition());
        }
        HashSet<String> createdTxMgrs = new HashSet<String>();
        Map map = configurer.getCdsRuntime().getEnvironment().getCdsProperties().getPersistence().getServices();
        for (CdsProperties.Persistence.PersistenceServiceConfig serviceConfig : map.values()) {
            String txMgrName;
            boolean isPrimary;
            String binding = StringUtils.isEmpty((String)serviceConfig.getBinding()) ? serviceConfig.getName() : serviceConfig.getBinding();
            AbstractBeanDefinition definition = (AbstractBeanDefinition)dataSourceBeanDefinitions.remove(binding);
            boolean bl = isPrimary = definition != null ? definition.isPrimary() : false;
            if (!serviceConfig.isEnabled().booleanValue()) continue;
            String dataSourceName = serviceConfig.getDataSource();
            if (StringUtils.isEmpty((String)dataSourceName)) {
                dataSourceName = "ds-" + binding;
                if (definition != null) {
                    registry.registerBeanDefinition(dataSourceName, (BeanDefinition)definition);
                    logger.info("Registered {}DataSource '{}'", (Object)(isPrimary ? "primary " : ""), (Object)dataSourceName);
                }
            }
            if (StringUtils.isEmpty((String)(txMgrName = serviceConfig.getTransactionManager())) && createdTxMgrs.add(txMgrName = "tx-" + binding)) {
                this.registerTransactionManager(registry, txMgrName, dataSourceName, isPrimary);
            }
            if (isPrimary) continue;
            this.registerPersistenceService(registry, configurer, serviceConfig.getName(), dataSourceName, txMgrName);
        }
        int count = dataSourceBeanDefinitions.size();
        for (Map.Entry definition : dataSourceBeanDefinitions.entrySet()) {
            String binding = (String)definition.getKey();
            String dataSourceName = "ds-" + binding;
            String txMgrName = "tx-" + binding;
            boolean isPrimary = ((AbstractBeanDefinition)definition.getValue()).isPrimary();
            registry.registerBeanDefinition(dataSourceName, (BeanDefinition)definition.getValue());
            logger.info("Registered {}DataSource '{}'", (Object)(isPrimary ? "primary " : ""), (Object)dataSourceName);
            this.registerTransactionManager(registry, txMgrName, dataSourceName, isPrimary);
            if (isPrimary || count <= 1) continue;
            this.registerPersistenceService(registry, configurer, binding, dataSourceName, txMgrName);
        }
    }

    private void registerTransactionManager(BeanDefinitionRegistry registry, String txMgrName, String dataSourceName, boolean isPrimary) {
        if (springJdbcAvailable) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceTransactionManagerBeanFactory.class);
            builder.addConstructorArgValue((Object)dataSourceName);
            builder.setPrimary(isPrimary);
            registry.registerBeanDefinition(txMgrName, (BeanDefinition)builder.getBeanDefinition());
            logger.info("Registered {}TransactionManager '{}'", (Object)(isPrimary ? "primary " : ""), (Object)txMgrName);
        }
    }

    private void registerPersistenceService(BeanDefinitionRegistry registry, CdsRuntimeConfigurer configurer, String binding, String dataSourceName, String txMgrName) {
        if (springJdbcAvailable && cdsJdbcAvailable) {
            BeanDefinitionBuilder persistenceServiceBuilder = BeanDefinitionBuilder.genericBeanDefinition(JdbcPersistenceServiceBeanFactory.class);
            persistenceServiceBuilder.addConstructorArgValue((Object)configurer);
            persistenceServiceBuilder.addConstructorArgValue((Object)binding);
            persistenceServiceBuilder.addConstructorArgValue((Object)dataSourceName);
            persistenceServiceBuilder.addConstructorArgValue((Object)txMgrName);
            registry.registerBeanDefinition(binding, (BeanDefinition)persistenceServiceBuilder.getBeanDefinition());
            logger.debug("Registered JdbcPersistenceServiceConfiguration '{}'", (Object)binding);
        }
    }

    private void registerServices(BeanDefinitionRegistry registry, CdsRuntime runtime) {
        runtime.getServiceCatalog().getServices().forEach(service -> {
            BeanDefinitionBuilder serviceBuilder = BeanDefinitionBuilder.genericBeanDefinition(service.getClass(), () -> service);
            registry.registerBeanDefinition(service.getName(), (BeanDefinition)serviceBuilder.getBeanDefinition());
        });
    }

    private void registerAdapters(BeanDefinitionRegistry registry, CdsRuntime runtime) {
        Iterator factoryIterator = ExtendedServiceLoader.loadAll(AdapterFactory.class, (CdsRuntime)runtime);
        while (factoryIterator.hasNext()) {
            AdapterFactory factory = (AdapterFactory)factoryIterator.next();
            if (factory instanceof ServletAdapterFactory && !springWebAvailable || !factory.isEnabled()) continue;
            String beanName = factory.getClass().getSimpleName();
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AdapterBeanFactory.class);
            builder.addConstructorArgValue((Object)factory);
            registry.registerBeanDefinition(beanName, (BeanDefinition)builder.getBeanDefinition());
            if (!(factory instanceof ServletAdapterFactory)) continue;
            ServletAdapterFactory servletFactory = (ServletAdapterFactory)factory;
            BeanDefinitionBuilder mappingBuilder = BeanDefinitionBuilder.genericBeanDefinition(SimpleUrlHandlerMapping.class, () -> {
                SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
                HashMap<String, String> urlMap = new HashMap<String, String>();
                for (String m : servletFactory.getMappings()) {
                    urlMap.put(m, beanName);
                }
                mapping.setOrder(0x7FFFFFFE);
                mapping.setUrlMap(urlMap);
                return mapping;
            });
            registry.registerBeanDefinition(beanName + "Mapping", (BeanDefinition)mappingBuilder.getBeanDefinition());
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    static {
        try {
            springWebAvailable = SimpleUrlHandlerMapping.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            springWebAvailable = false;
        }
        try {
            springJdbcAvailable = DataSourceTransactionManager.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            springJdbcAvailable = false;
        }
        try {
            cdsJdbcAvailable = JdbcPersistenceServiceConfiguration.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            cdsJdbcAvailable = false;
        }
    }
}

