/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.utils;

import com.sap.cds.services.mt.DeploymentService;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(basePackages={"${cds.multitenancy.deploy.component-scan:acme.xyy}", "${cds.deploy.component-scan:acme.xyz}"})
public class Deploy {
    private static final Logger logger = LoggerFactory.getLogger(Deploy.class);

    public static void main(String[] args) throws Exception {
        try {
            String[] tenants;
            System.setProperty("cds.security.xsuaa.enabled", "false");
            System.setProperty("cds.security.mock.enabled", "false");
            System.setProperty("cds.messaging.webhooks.enabled", "false");
            CdsRuntime runtime = (CdsRuntime)new SpringApplicationBuilder(new Class[]{Deploy.class}).web(WebApplicationType.NONE).run(new String[0]).getBean(CdsRuntime.class);
            DeploymentService deploymentService = (DeploymentService)runtime.getServiceCatalog().getService(DeploymentService.class, "DeploymentService$Default");
            TenantProviderService tenantService = (TenantProviderService)runtime.getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
            assert (!runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().isEnabled().booleanValue());
            assert (!runtime.getEnvironment().getCdsProperties().getSecurity().getMock().isEnabled().booleanValue());
            assert (!runtime.getEnvironment().getCdsProperties().getMessaging().getWebhooks().isEnabled().booleanValue());
            if (deploymentService == null) {
                logger.error("Failed to find DeploymentService");
                Deploy.logErrorMessage();
                System.exit(2);
            }
            if (args.length == 0) {
                logger.info("Obtaining all subscribed tenants");
                tenants = tenantService.readTenants().toArray(new String[0]);
            } else {
                tenants = args;
            }
            if (tenants.length != 0) {
                long timestamp = System.currentTimeMillis();
                runtime.requestContext().privilegedUser().run(context -> {
                    logger.info("Starting upgrade for tenant(s) '{}'", (Object)String.join((CharSequence)",", tenants));
                    deploymentService.upgrade(Arrays.asList(tenants), null);
                });
                logger.info("Upgrade finished successfully in {}s", (Object)((System.currentTimeMillis() - timestamp) / 1000L));
            } else {
                logger.info("No tenants specified and there are no subscribed tenants. No upgrade necessary.");
            }
            Deploy.logSuccessMessage();
            System.exit(0);
        }
        catch (Throwable t) {
            logger.error("Failed to perform tenant upgrade", t);
            Deploy.logErrorMessage();
            System.exit(1);
        }
    }

    private static void logSuccessMessage() {
        logger.info("*************");
        logger.info("*  SUCCESS  *");
        logger.info("*************");
    }

    private static void logErrorMessage() {
        logger.error("***********");
        logger.error("*  ERROR  *");
        logger.error("***********");
    }
}

