/**************************************************************************
 * (C) 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.utils;

import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

/**
 * Class providing a main method to upgrade the tenant.
 * This main method starts the whole server. Therefore, all background tasks that might be registered will also start.
 * If this could lead to problems, they need to be deactivated.
 */
@SpringBootApplication
@ComponentScan(basePackages = {"${cds.multitenancy.component-scan:acme.xyy}",
		"${cds.multitenancy.deploy.component-scan:acme.xyy}", "${cds.deploy.component-scan:acme.xyz}"}) // compatibility only
public class Deploy {

	private static final Logger logger = LoggerFactory.getLogger(Deploy.class);

	public static void main(String[] args) throws Exception {
		MtCommand.execute(Deploy.class, (deploymentService, runtime, startTime) -> {
			List<String> tenants = MtCommand.getTenants(args, runtime);
			Map<String, Object> options = MtCommand.getOptions(args, false);
			if (!tenants.isEmpty()) {
				logger.info("Starting upgrade for tenant(s) '{}'", String.join(",", tenants));
				deploymentService.upgrade(tenants, options);
				logger.info("Upgrade finished successfully in {}s", (System.currentTimeMillis() - startTime) / 1000);
			} else {
				logger.info("No tenants specified and there are no subscribed tenants. No upgrade necessary.");
			}
		});
	}
}
