/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.datasource;

import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class DataSourceTransactionManagerBeanFactory
implements FactoryBean<DataSourceTransactionManager>,
BeanFactoryAware {
    private final String dataSourceName;
    private BeanFactory beanFactory;
    private DataSourceTransactionManager txMgr;

    public DataSourceTransactionManagerBeanFactory(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public DataSourceTransactionManager getObject() throws Exception {
        if (this.txMgr == null) {
            DataSource dataSource = (DataSource)this.beanFactory.getBean(this.dataSourceName, DataSource.class);
            this.txMgr = new DataSourceTransactionManager(dataSource);
        }
        return this.txMgr;
    }

    public Class<?> getObjectType() {
        return DataSourceTransactionManager.class;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

