/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.utils;

import com.sap.cds.framework.spring.utils.MtCommand;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(basePackages={"${cds.multitenancy.component-scan:acme.xyy}", "${cds.multitenancy.deploy.component-scan:acme.xyy}", "${cds.deploy.component-scan:acme.xyz}"})
public class Deploy {
    private static final Logger logger = LoggerFactory.getLogger(Deploy.class);

    public static void main(String[] args) throws Exception {
        MtCommand.execute(Deploy.class, (deploymentService, runtime, startTime) -> {
            List<String> tenants = MtCommand.getTenants(args, runtime);
            Map<String, Object> options = MtCommand.getOptions(args, false);
            if (!tenants.isEmpty()) {
                logger.info("Starting upgrade for tenant(s) '{}'", (Object)String.join((CharSequence)",", tenants));
                deploymentService.upgrade(tenants, options);
                logger.info("Upgrade finished successfully in {}s", (Object)((System.currentTimeMillis() - startTime) / 1000L));
            } else {
                logger.info("No tenants specified and there are no subscribed tenants. No upgrade necessary.");
            }
        });
    }
}

