/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.services.mt.DeploymentService;
import com.sap.cds.services.mt.TenantProviderService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;

public class MtCommand {
    private static final Logger logger = LoggerFactory.getLogger(MtCommand.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String ENV_TENANTS = "MTCOMMAND_TENANTS";
    private static final String ENV_OPTIONS = "MTCOMMAND_OPTIONS";

    static void execute(Class<?> clazz, Task task) {
        try {
            System.setProperty("cds.security.identity.enabled", "false");
            System.setProperty("cds.security.xsuaa.enabled", "false");
            System.setProperty("cds.security.mock.enabled", "false");
            System.setProperty("cds.messaging.webhooks.enabled", "false");
            CdsRuntime runtime = (CdsRuntime)new SpringApplicationBuilder(new Class[]{clazz}).web(WebApplicationType.NONE).run(new String[0]).getBean(CdsRuntime.class);
            DeploymentService deploymentService = (DeploymentService)runtime.getServiceCatalog().getService(DeploymentService.class, "DeploymentService$Default");
            assert (!runtime.getEnvironment().getCdsProperties().getSecurity().getIdentity().isEnabled().booleanValue());
            assert (!runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().isEnabled().booleanValue());
            assert (!runtime.getEnvironment().getCdsProperties().getSecurity().getMock().isEnabled().booleanValue());
            assert (!runtime.getEnvironment().getCdsProperties().getMessaging().getWebhooks().isEnabled().booleanValue());
            if (deploymentService == null) {
                logger.error("Failed to find DeploymentService");
                MtCommand.logErrorMessage();
                System.exit(2);
            }
            runtime.requestContext().privilegedUser().run(context -> task.execute(deploymentService, runtime, System.currentTimeMillis()));
            MtCommand.logSuccessMessage();
            System.exit(0);
        }
        catch (Throwable t) {
            logger.error("Failed to perform command '{}'", (Object)clazz.getSimpleName(), (Object)t);
            MtCommand.logErrorMessage();
            System.exit(1);
        }
    }

    static String getTenant(String[] args) {
        String tenant;
        if (args.length > 0) {
            tenant = args[0];
        } else {
            tenant = System.getenv(ENV_TENANTS);
            if (tenant.contains(",")) {
                logger.error("Specify only one tenant");
                MtCommand.logErrorMessage();
                System.exit(2);
            }
        }
        if (StringUtils.isEmpty((String)tenant)) {
            logger.error("No tenant specified");
            MtCommand.logErrorMessage();
            System.exit(2);
        }
        return tenant;
    }

    static List<String> getTenants(String[] args, CdsRuntime runtime) {
        List tenants;
        if (args.length > 0) {
            tenants = Arrays.asList(args);
        } else {
            String tenantsEnv = System.getenv(ENV_TENANTS);
            if (!StringUtils.isEmpty((String)tenantsEnv)) {
                tenants = Arrays.asList(tenantsEnv.split(","));
            } else {
                logger.info("Obtaining all subscribed tenants");
                TenantProviderService tenantService = (TenantProviderService)runtime.getServiceCatalog().getService(TenantProviderService.class, "TenantProviderService$Default");
                tenants = tenantService.readTenants();
            }
        }
        return tenants;
    }

    static Map<String, Object> getOptions(String[] args, boolean optionsOnCommandline) {
        try {
            String optionsEnvVar;
            Map<Object, Object> options = optionsOnCommandline && args.length > 1 ? (Map)mapper.readValue(args[1], (TypeReference)new TypeReference<Map<String, Object>>(){}) : ((optionsEnvVar = System.getenv(ENV_OPTIONS)) != null ? (Map)mapper.readValue(optionsEnvVar, (TypeReference)new TypeReference<Map<String, Object>>(){}) : new HashMap<String, Object>());
            return options;
        }
        catch (JsonProcessingException e) {
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private static void logSuccessMessage() {
        logger.info("*************");
        logger.info("*  SUCCESS  *");
        logger.info("*************");
    }

    private static void logErrorMessage() {
        logger.error("***********");
        logger.error("*  ERROR  *");
        logger.error("***********");
    }

    @FunctionalInterface
    static interface Task {
        public void execute(DeploymentService var1, CdsRuntime var2, long var3);
    }
}

