/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.utils;

import com.sap.cds.framework.spring.utils.MtCommand;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(basePackages={"${cds.multitenancy.component-scan:acme.xyy}"})
public class Subscribe {
    private static final Logger logger = LoggerFactory.getLogger(Subscribe.class);

    public static void main(String[] args) throws Exception {
        MtCommand.execute(Subscribe.class, (deploymentService, runtime, startTime) -> {
            String tenant = MtCommand.getTenant(args);
            Map<String, Object> options = MtCommand.getOptions(args, true);
            logger.info("Starting subscribe for tenant '{}'", (Object)tenant);
            deploymentService.subscribe(tenant, options);
            logger.info("Subscribe finished successfully in {}s", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        });
    }
}

