/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.utils;

import com.sap.cds.framework.spring.utils.MtCommand;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication
@ComponentScan(basePackages={"${cds.multitenancy.component-scan:acme.xyy}"})
public class Unsubscribe {
    private static final Logger logger = LoggerFactory.getLogger(Unsubscribe.class);

    public static void main(String[] args) throws Exception {
        MtCommand.execute(Unsubscribe.class, (deploymentService, runtime, startTime) -> {
            String tenant = MtCommand.getTenant(args);
            Map<String, Object> options = MtCommand.getOptions(args, true);
            logger.info("Starting unsubscribe for tenant '{}'", (Object)tenant);
            deploymentService.unsubscribe(tenant, options);
            logger.info("Unsubscribe finished successfully in {}s", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        });
    }
}

