/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.runtime;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

@AutoConfiguration
public class CdsRuntimeBeanConfig {

	private final BootstrapCache bootstrapCache;

	public CdsRuntimeBeanConfig(Environment environment) {
		bootstrapCache = BootstrapCache.get(environment).ensureServices();
	}

	@Bean
	public BootstrapCache bootstrapCache() {
		return bootstrapCache;
	}

	@Bean
	public CdsRuntimeConfigurer cdsRuntimeConfigurer() {
		return bootstrapCache.getConfigurer();
	}

	@Bean
	public CdsRuntime cdsRuntime() {
		return bootstrapCache.getCdsRuntime();
	}

}
