package com.sap.cds.framework.spring.config.adapter;

import java.util.HashMap;
import java.util.Map;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.framework.spring.config.runtime.CdsRuntimeBeanDefinitionRegistrar;
import com.sap.cds.framework.spring.config.runtime.CdsRuntimeInitializer;

@ConditionalOnWebApplication
@ConditionalOnClass(SimpleUrlHandlerMapping.class)
@AutoConfiguration(after = CdsRuntimeBeanDefinitionRegistrar.class, before = CdsRuntimeInitializer.class)
public class SimpleUrlHandlerMappingConfig {

	@Bean
	public SimpleUrlHandlerMapping adapterMappings(BootstrapCache bootstrapCache) {
		SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
		Map<String, String> urlMap = new HashMap<>();

		for(Map.Entry<String, AdapterFactory> entry : bootstrapCache.getAdapterFactories().entrySet()) {
			AdapterFactory factory = entry.getValue();
			if(factory.isEnabled() && factory instanceof ServletAdapterFactory) {
				String beanName = entry.getKey();
				ServletAdapterFactory servletFactory = (ServletAdapterFactory) factory;
				for(String m : servletFactory.getMappings()) {
					urlMap.put(m, beanName);
				}
			}
		}

		// make sure priority is before static resources, which have Ordered.LOWEST_PRECEDENCE - 1
		mapping.setOrder(Ordered.LOWEST_PRECEDENCE - 2);
		mapping.setUrlMap(urlMap);
		return mapping;
	}

}
