/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth.xsuaa;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.XsuaaUtils;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.XsuaaServicePropertySourceFactory;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class XsuaaEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(XsuaaEnvironmentPostProcessor.class);
    private static final String PROPERTYSOURCE_NAME = "cds-xsuaa";
    private static boolean xsuaaLibraryAvailable;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        if (!xsuaaLibraryAvailable) {
            return;
        }
        CdsRuntime runtime = BootstrapCache.get((Environment)environment).getCdsRuntime();
        XsuaaUtils xsuaaUtils = new XsuaaUtils(runtime);
        if (!xsuaaUtils.xsuaaAuthenticationConfigured()) {
            return;
        }
        environment.getPropertySources().addLast(this.createPropertySource(runtime));
    }

    private PropertySource<?> createPropertySource(CdsRuntime runtime) {
        XsuaaUtils xsuaaUtils = new XsuaaUtils(runtime);
        List bindings = xsuaaUtils.getXsuaaServiceBindings();
        if (bindings.isEmpty()) {
            String xsuaaServiceBinding = runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().getBinding();
            if (StringUtils.isEmpty((String)xsuaaServiceBinding)) {
                logger.info("No service binding with tag 'xsuaa' found");
            } else {
                logger.info("No service binding with tag 'xsuaa' and name '{}' found", (Object)xsuaaServiceBinding);
            }
            return new PropertiesPropertySource(PROPERTYSOURCE_NAME, new Properties());
        }
        if (bindings.size() > 1) {
            logger.warn("Multiple service bindings with tag 'xsuaa' found");
        }
        ServiceBinding binding = (ServiceBinding)bindings.get(0);
        logger.info("Using service binding '{}' to configure 'xsuaa' properties section", (Object)binding.getName());
        Properties props = new Properties();
        props.putAll((Map<?, ?>)binding.getCredentials());
        return XsuaaServicePropertySourceFactory.create((String)PROPERTYSOURCE_NAME, (Properties)props);
    }

    static {
        try {
            xsuaaLibraryAvailable = XsuaaServiceConfiguration.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            xsuaaLibraryAvailable = false;
        }
    }
}

