/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth;

import com.sap.cds.adapter.ServletUrlResourcePaths;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.framework.spring.config.auth.HttpSecurityConfigurer;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@AutoConfiguration
@ConditionalOnClass(value={WebSecurityConfigurer.class})
public class CdsHttpSecurityConfigurerConfig {
    @Bean
    @ConditionalOnMissingBean
    public HttpSecurityConfigurer httpSecurityConfigurer(CdsRuntime runtime) {
        return new CdsModelBasedSecurityConfigurer(runtime);
    }

    private static class CdsModelBasedSecurityConfigurer
    implements HttpSecurityConfigurer {
        private static final Logger logger = LoggerFactory.getLogger(CdsModelBasedSecurityConfigurer.class);
        private final CdsRuntime runtime;

        public CdsModelBasedSecurityConfigurer(CdsRuntime runtime) {
            this.runtime = runtime;
        }

        @Override
        public void configure(HttpSecurity http) throws Exception {
            ServletUrlResourcePaths servletPaths = new ServletUrlResourcePaths(this.runtime);
            if (!this.runtime.getEnvironment().getCdsProperties().getSecurity().getAuthentication().isAuthenticateUnknownEndpoints()) {
                http.securityMatchers().requestMatchers((RequestMatcher[])servletPaths.getBasePaths().map(UrlResourcePath::getPath).map(AntPathRequestMatcher::antMatcher).toArray(RequestMatcher[]::new));
                logger.info("Configuring authentication of CDS adapter endpoints. Other endpoints are not configured.");
            }
            final AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry urlRegistry = http.authorizeHttpRequests();
            servletPaths.visit(new ServletUrlResourcePaths.UrlResourcePathVisitor(){

                public void foundPublicPath(UrlResourcePath publicPath) {
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)publicPath.getPath())})).permitAll();
                    logger.debug("Public CDS endpoint {}", (Object)publicPath.getPath());
                }

                public void foundPublicEvents(UrlResourcePath path, Stream<String> publicEvents) {
                    publicEvents.forEach(publicEvent -> {
                        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((HttpMethod)HttpMethod.valueOf((String)publicEvent), (String)path.getPath())})).permitAll();
                        logger.debug("Public CDS endpoint {} {}", publicEvent, (Object)path.getPath());
                    });
                    ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)path.getPath())})).authenticated();
                    logger.debug("Authenticate CDS endpoint {}", (Object)path.getPath());
                }
            });
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).authenticated();
        }
    }
}

