/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.services.environment.PropertiesProvider;
import java.util.Map;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public class SpringPropertiesProvider
implements PropertiesProvider {
    private final Environment environment;

    public SpringPropertiesProvider(Environment environment) {
        this.environment = environment;
    }

    public <T> T bindPropertyClass(String section, Class<T> clazz) {
        BindResult bindResult = Binder.get((Environment)this.environment).bind(section, Bindable.of(clazz));
        if (bindResult.isBound()) {
            return (T)bindResult.get();
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public String getProperty(String key, String defaultValue) {
        return this.environment.getProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> clazz, T defaultValue) {
        if (Map.class.isAssignableFrom(clazz)) {
            return this.bindPropertyClass(key, clazz);
        }
        return (T)this.environment.getProperty(key, clazz, defaultValue);
    }
}

