/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.aot;

import com.sap.cds.framework.spring.config.datasource.PlatformTransactionManagerPostProcessor;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import java.util.Arrays;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.transaction.PlatformTransactionManager;

public class CdsBeanFactoryAwareRuntimeHints
implements BeanFactoryInitializationAotProcessor {
    private static boolean springTxAvailable;

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        return (generationContext, beanFactoryInitializationCode) -> {
            RuntimeHints hints = generationContext.getRuntimeHints();
            CdsRuntimeConfigurer configurer = (CdsRuntimeConfigurer)beanFactory.getBean(CdsRuntimeConfigurer.class);
            CdsProperties properties = configurer.getCdsRuntime().getEnvironment().getCdsProperties();
            hints.resources().registerPattern(properties.getModel().getCsnPath()).registerPattern(properties.getOdataV4().getEdmxPath() + "/.*").registerPattern(properties.getOdataV2().getEdmxPath() + "/.*");
            if (springTxAvailable) {
                Arrays.stream(beanFactory.getBeanNamesForType(PlatformTransactionManager.class)).map(name -> beanFactory.getType(name)).forEach(clazz -> hints.proxies().registerJdkProxy((Class[])PlatformTransactionManagerPostProcessor.determineProxyInterfaces(clazz)));
            }
        };
    }

    static {
        try {
            springTxAvailable = PlatformTransactionManager.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            springTxAvailable = false;
        }
    }
}

