/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.framework.spring.config.adapter.AdapterBeanFactory;
import com.sap.cds.framework.spring.config.datasource.DataSourceBeanFactory;
import com.sap.cds.framework.spring.config.datasource.DataSourceDescriptorBeanFactory;
import com.sap.cds.framework.spring.config.datasource.DataSourceTransactionManagerBeanFactory;
import com.sap.cds.framework.spring.config.datasource.JdbcPersistenceServiceBeanFactory;
import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.framework.spring.config.runtime.ServiceBeanFactory;
import com.sap.cds.services.datasource.DataSourceDescriptor;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.impl.persistence.JdbcPersistenceServiceConfiguration;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.StringUtils;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;

public class CdsRuntimeBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(CdsRuntimeBeanDefinitionRegistrar.class);
    private static boolean springWebAvailable;
    private static boolean springJdbcAvailable;
    private static boolean cdsJdbcAvailable;
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        BootstrapCache bootstrapCache = BootstrapCache.get(this.environment).ensureServices();
        this.registerDataSources(registry, bootstrapCache);
        this.registerServices(registry, bootstrapCache.getCdsRuntime());
        if (!bootstrapCache.getCdsRuntime().getEnvironment().getCdsProperties().getEnvironment().getCommand().isEnabled().booleanValue()) {
            this.registerAdapters(registry, bootstrapCache.getAdapterFactories());
        }
    }

    private void registerDataSources(BeanDefinitionRegistry registry, BootstrapCache bootstrapCache) {
        CdsProperties properties = bootstrapCache.getCdsRuntime().getEnvironment().getCdsProperties();
        String springDataSourceUrl = this.environment.getProperty("spring.datasource.url");
        if (springDataSourceUrl != null) {
            if (springDataSourceUrl.contains(":sqlite:") && springDataSourceUrl.contains(":memory:")) {
                logger.debug("Determined DataSource as embedded based on 'spring.datasource.url' configuration.");
                properties.getDataSource().setEmbedded(true);
            }
            logger.info("Found 'spring.datasource.url' configuration: Auto-configuration of DataSource beans is disabled.");
            return;
        }
        if (!properties.getDataSource().getAutoConfig().isEnabled().booleanValue()) {
            logger.info("Auto-configuration of DataSource beans is explicitly disabled.");
            return;
        }
        LinkedHashMap<String, AbstractBeanDefinition> dataSourceBeanDefinitions = new LinkedHashMap<String, AbstractBeanDefinition>();
        for (DataSourceDescriptor dataSourceDescriptor : bootstrapCache.getDataSourceDescriptors()) {
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceDescriptorBeanFactory.class);
            beanDefinitionBuilder.addConstructorArgValue((Object)dataSourceDescriptor.getName());
            beanDefinitionBuilder.setPrimary(dataSourceDescriptor.getName().equals(properties.getDataSource().getBinding()));
            dataSourceBeanDefinitions.put(dataSourceDescriptor.getName(), beanDefinitionBuilder.getBeanDefinition());
        }
        Map<String, DataSource> dataSources = bootstrapCache.getDataSources();
        for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceBeanFactory.class);
            builder.addConstructorArgValue((Object)entry.getKey());
            builder.addConstructorArgValue(entry.getValue().getClass());
            builder.setPrimary(entry.getKey().equals(properties.getDataSource().getBinding()));
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            beanDefinition.setAttribute("factoryBeanObjectType", entry.getValue().getClass());
            dataSourceBeanDefinitions.put(entry.getKey(), beanDefinition);
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        Map map = properties.getPersistence().getServices();
        for (CdsProperties.Persistence.PersistenceServiceConfig serviceConfig : map.values()) {
            Object txMgrName;
            boolean isPrimary;
            String binding = StringUtils.isEmpty((String)serviceConfig.getBinding()) ? serviceConfig.getName() : serviceConfig.getBinding();
            AbstractBeanDefinition definition = (AbstractBeanDefinition)dataSourceBeanDefinitions.remove(binding);
            boolean bl = isPrimary = definition != null ? definition.isPrimary() : false;
            if (!serviceConfig.isEnabled().booleanValue()) continue;
            Object dataSourceName = serviceConfig.getDataSource();
            if (StringUtils.isEmpty((String)dataSourceName)) {
                dataSourceName = "ds-" + binding;
                if (definition != null) {
                    registry.registerBeanDefinition((String)dataSourceName, (BeanDefinition)definition);
                    logger.info("Registered {}DataSource '{}'", (Object)this.isPrimaryLiteral(isPrimary), dataSourceName);
                }
            }
            if (StringUtils.isEmpty((String)(txMgrName = serviceConfig.getTransactionManager())) && hashSet.add(txMgrName = "tx-" + binding)) {
                this.registerTransactionManager(registry, (String)txMgrName, (String)dataSourceName, isPrimary);
            }
            if (isPrimary) continue;
            this.registerPersistenceService(registry, serviceConfig.getName(), (String)dataSourceName, (String)txMgrName);
        }
        int count = dataSourceBeanDefinitions.size();
        for (Map.Entry definition : dataSourceBeanDefinitions.entrySet()) {
            String binding = (String)definition.getKey();
            String dataSourceName = "ds-" + binding;
            String txMgrName = "tx-" + binding;
            boolean isPrimary = ((AbstractBeanDefinition)definition.getValue()).isPrimary();
            registry.registerBeanDefinition(dataSourceName, (BeanDefinition)definition.getValue());
            logger.info("Registered {}DataSource '{}'", (Object)this.isPrimaryLiteral(isPrimary), (Object)dataSourceName);
            this.registerTransactionManager(registry, txMgrName, dataSourceName, isPrimary);
            if (isPrimary || count <= 1) continue;
            this.registerPersistenceService(registry, binding, dataSourceName, txMgrName);
        }
    }

    private void registerTransactionManager(BeanDefinitionRegistry registry, String txMgrName, String dataSourceName, boolean isPrimary) {
        if (springJdbcAvailable) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(DataSourceTransactionManagerBeanFactory.class);
            builder.addConstructorArgValue((Object)dataSourceName);
            builder.setPrimary(isPrimary);
            registry.registerBeanDefinition(txMgrName, (BeanDefinition)builder.getBeanDefinition());
            logger.info("Registered {}TransactionManager '{}'", (Object)this.isPrimaryLiteral(isPrimary), (Object)txMgrName);
        }
    }

    private void registerPersistenceService(BeanDefinitionRegistry registry, String binding, String dataSourceName, String txMgrName) {
        if (springJdbcAvailable && cdsJdbcAvailable) {
            BeanDefinitionBuilder persistenceServiceBuilder = BeanDefinitionBuilder.genericBeanDefinition(JdbcPersistenceServiceBeanFactory.class);
            persistenceServiceBuilder.addConstructorArgValue((Object)binding);
            persistenceServiceBuilder.addConstructorArgValue((Object)dataSourceName);
            persistenceServiceBuilder.addConstructorArgValue((Object)txMgrName);
            registry.registerBeanDefinition(binding, (BeanDefinition)persistenceServiceBuilder.getBeanDefinition());
            logger.debug("Registered JdbcPersistenceServiceConfiguration '{}'", (Object)binding);
        }
    }

    private void registerServices(BeanDefinitionRegistry registry, CdsRuntime runtime) {
        runtime.getServiceCatalog().getServices().forEach(service -> {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ServiceBeanFactory.class);
            builder.addConstructorArgValue((Object)service.getName());
            builder.addConstructorArgValue(service.getClass());
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            beanDefinition.setAttribute("factoryBeanObjectType", service.getClass());
            registry.registerBeanDefinition(service.getName(), (BeanDefinition)beanDefinition);
        });
    }

    private void registerAdapters(BeanDefinitionRegistry registry, Map<String, AdapterFactory> adapterFactories) {
        for (Map.Entry<String, AdapterFactory> entry : adapterFactories.entrySet()) {
            AdapterFactory factory = entry.getValue();
            if (factory instanceof ServletAdapterFactory && !springWebAvailable || !factory.isEnabled()) continue;
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(AdapterBeanFactory.class);
            builder.addConstructorArgValue((Object)entry.getKey());
            registry.registerBeanDefinition(entry.getKey(), (BeanDefinition)builder.getBeanDefinition());
        }
    }

    private String isPrimaryLiteral(boolean isPrimary) {
        return isPrimary ? "primary " : "";
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    static {
        try {
            springWebAvailable = SimpleUrlHandlerMapping.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            springWebAvailable = false;
        }
        try {
            springJdbcAvailable = DataSourceTransactionManager.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            springJdbcAvailable = false;
        }
        try {
            cdsJdbcAvailable = JdbcPersistenceServiceConfiguration.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            cdsJdbcAvailable = false;
        }
    }
}

