/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.adapter;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.framework.spring.config.runtime.CdsRuntimeBeanDefinitionRegistrar;
import com.sap.cds.framework.spring.config.runtime.CdsRuntimeInitializer;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;

@ConditionalOnWebApplication
@ConditionalOnClass(value={SimpleUrlHandlerMapping.class})
@AutoConfiguration(after={CdsRuntimeBeanDefinitionRegistrar.class}, before={CdsRuntimeInitializer.class})
public class SimpleUrlHandlerMappingConfig {
    @Bean
    public SimpleUrlHandlerMapping adapterMappings(BootstrapCache bootstrapCache) {
        SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
        HashMap<String, String> urlMap = new HashMap<String, String>();
        for (Map.Entry<String, AdapterFactory> entry : bootstrapCache.getAdapterFactories().entrySet()) {
            AdapterFactory factory = entry.getValue();
            if (!factory.isEnabled() || !(factory instanceof ServletAdapterFactory)) continue;
            String beanName = entry.getKey();
            ServletAdapterFactory servletFactory = (ServletAdapterFactory)factory;
            for (String m : servletFactory.getMappings()) {
                urlMap.put(m, beanName);
            }
        }
        mapping.setOrder(0x7FFFFFFD);
        mapping.setUrlMap(urlMap);
        return mapping;
    }
}

