/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.framework.spring.config.runtime.SpringPropertiesProvider;
import com.sap.cds.services.datasource.DataSourceDescriptor;
import com.sap.cds.services.environment.PropertiesProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.runtime.ExtendedServiceLoader;
import com.sap.cds.services.utils.datasource.DataSourceUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.core.env.Environment;

public class BootstrapCache {
    private static final Map<Environment, BootstrapCache> cache = Collections.synchronizedMap(new HashMap());
    private final CdsRuntimeConfigurer configurer;
    private boolean servicesInitialized;
    private Map<String, AdapterFactory> adapterFactories;
    private List<DataSourceDescriptor> dataSourceDescriptors;
    private Map<String, DataSource> dataSources;

    public static BootstrapCache get(Environment environment) {
        return cache.computeIfAbsent(environment, BootstrapCache::new);
    }

    public static void clear(Environment environment) {
        cache.remove(environment);
    }

    private BootstrapCache(Environment environment) {
        this.configurer = CdsRuntimeConfigurer.create((PropertiesProvider)new SpringPropertiesProvider(environment)).environmentConfigurations();
    }

    public BootstrapCache ensureServices() {
        if (!this.servicesInitialized) {
            this.configurer.cdsModel().serviceConfigurations();
            this.servicesInitialized = true;
        }
        return this;
    }

    public CdsRuntimeConfigurer getConfigurer() {
        return this.configurer;
    }

    public CdsRuntime getCdsRuntime() {
        return this.configurer.getCdsRuntime();
    }

    public Map<String, AdapterFactory> getAdapterFactories() {
        if (this.adapterFactories == null) {
            this.ensureServices();
            HashMap factories = new HashMap();
            ExtendedServiceLoader.loadAll(AdapterFactory.class, (CdsRuntime)this.configurer.getCdsRuntime()).forEachRemaining(f -> factories.put(f.getClass().getSimpleName(), f));
            this.adapterFactories = Collections.unmodifiableMap(factories);
        }
        return this.adapterFactories;
    }

    public List<DataSourceDescriptor> getDataSourceDescriptors() {
        if (this.dataSourceDescriptors == null) {
            this.dataSourceDescriptors = Collections.unmodifiableList(DataSourceUtils.getDataSourceDescriptors((CdsRuntime)this.configurer.getCdsRuntime()));
        }
        return this.dataSourceDescriptors;
    }

    public Map<String, DataSource> getDataSources() {
        if (this.dataSources == null) {
            this.dataSources = Collections.unmodifiableMap(DataSourceUtils.getDataSources((CdsRuntime)this.configurer.getCdsRuntime()));
        }
        return this.dataSources;
    }
}

