/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth.xsuaa;

import com.sap.cds.framework.spring.config.auth.HttpSecurityConfigurer;
import com.sap.cds.framework.spring.config.auth.xsuaa.XsuaaConfiguredCondition;
import com.sap.cds.framework.spring.config.auth.xsuaa.XsuaaFeature;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.XsuaaUtils;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.token.TokenAuthenticationConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.web.SecurityFilterChain;

@AutoConfiguration
@ConditionalOnClass(value={XsuaaServiceConfiguration.class, HttpSecurity.class, Jwt.class})
@Conditional(value={XsuaaConfiguredCondition.class})
@ConditionalOnWebApplication
@EnableWebSecurity
@Order(value=1000)
public class XsuaaSecurityConfig {
    private static final Logger logger = LoggerFactory.getLogger(XsuaaSecurityConfig.class);
    @Autowired
    private CdsRuntime runtime;
    @Autowired
    private XsuaaServiceConfiguration xsuaaServiceConfiguration;
    @Autowired
    private HttpSecurityConfigurer httpSecurityConfigurer;
    @Autowired
    private XsuaaFeature xsuaaFeatue;

    @Bean
    public SecurityFilterChain xsuaaFilterChain(HttpSecurity http) throws Exception {
        if (!this.xsuaaFeatue.isActive()) {
            throw new IllegalStateException("XSUAA configuration requires dependency to cds-feature-xsuaa. Alternatively, deactivate this security configuration with property 'cds.security.xsuaa.enabled: false' AND provide your own configuration.");
        }
        XsuaaUtils.AuthenticationType authType = new XsuaaUtils(this.runtime).configuredAuthenticationType();
        http.sessionManagement(session -> session.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        this.httpSecurityConfigurer.configure(http);
        http.oauth2ResourceServer(resourceServer -> resourceServer.jwt(customizer -> customizer.jwtAuthenticationConverter(this.getJwtAuthoritiesConverter())));
        switch (authType) {
            case XSUAA: {
                logger.info("Activated XSUAA security configuration");
                break;
            }
            default: {
                throw new IllegalStateException("Configuration error: Can't configure authentication without a binding to XSUAA service");
            }
        }
        return (SecurityFilterChain)http.build();
    }

    private Converter<Jwt, AbstractAuthenticationToken> getJwtAuthoritiesConverter() {
        TokenAuthenticationConverter converter = new TokenAuthenticationConverter(this.xsuaaServiceConfiguration);
        converter.setLocalScopeAsAuthorities(true);
        return converter;
    }
}

