/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth.xsuaa;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

import com.sap.cds.feature.xsuaa.XsuaaUserInfoProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.XsuaaUtils;

@AutoConfiguration(before = DefaultXsuaaFeatureConfig.class)
@ConditionalOnClass(XsuaaUserInfoProvider.class) // optionally loaded with cds-feature-xsuaa
public class LoadedXsuaaFeatureConfig {

	@Bean
	public XsuaaFeature xsuaaFeature(CdsRuntime runtime) {
		XsuaaUtils xsuaaUtils = new XsuaaUtils(runtime);
		return () -> xsuaaUtils.xsuaaAuthenticationConfigured();
	}

}
