/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth.xsuaa;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.PropertySource;

import com.sap.cloud.security.xsuaa.XsuaaServiceConfiguration;
import com.sap.cloud.security.xsuaa.XsuaaServiceConfigurationDefault;
import com.sap.cloud.security.xsuaa.extractor.TokenUtil;

@AutoConfiguration
@ConditionalOnClass(XsuaaServiceConfiguration.class) // only if xsuaa library has been loaded
@PropertySource("classpath:/com/sap/cds/xsuaa.properties") // disable xsuaa property source
public class XsuaaConfigurationConfig {

	@Bean
	@ConditionalOnMissingBean(XsuaaServiceConfiguration.class)
	@Conditional(XsuaaConfiguredCondition.class)
	public XsuaaServiceConfigurationDefault xsuaaServiceConfiguration() {
		return new XsuaaServiceConfigurationDefault();
	}

	@Bean
	public TokenUtil tokenUtil() {
		return new TokenUtil();
	}

}
