/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth.xsuaa;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.XsuaaUtils;

/**
 * A {@link Condition} that helps to decide if XSUAA is configured or not.
 * Note that the xsuaa properties could be injected via custom XsuaaServicePropertySourceFactory.
 */
public class XsuaaConfiguredCondition implements Condition {

	@Override
	@SuppressWarnings("deprecation")
	public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
		CdsRuntime runtime = BootstrapCache.get(context.getEnvironment()).getCdsRuntime();
		return (new XsuaaUtils(runtime).xsuaaAuthenticationConfigured()) &&
				runtime.getEnvironment().getCdsProperties().getSecurity().getAuthentication().getAuthConfig().isEnabled() &&
					runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().getAuthConfig().isEnabled();
	}

}
