/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth.xsuaa;

import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportRuntimeHints;

import com.sap.cds.feature.xsuaa.XsuaaUserInfo;
import com.sap.cds.framework.spring.config.auth.xsuaa.XsuaaUserInfoConfig.XsuaaUserInfoRuntimeHints;
import com.sap.cds.framework.spring.utils.ProxyUtils;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;

@AutoConfiguration
@ConditionalOnClass(XsuaaUserInfo.class)
@ImportRuntimeHints(XsuaaUserInfoRuntimeHints.class)
public class XsuaaUserInfoConfig {

	static class XsuaaUserInfoRuntimeHints implements RuntimeHintsRegistrar {

		@Override
		public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
			hints.proxies().registerJdkProxy(XsuaaUserInfo.class);
		}

	}

	@Bean
	public XsuaaUserInfo xsuaaUserInfo(CdsRuntime runtime) {
		return ProxyUtils.createProxy(XsuaaUserInfo.class, () -> RequestContext.getCurrent(runtime).getUserInfo().as(XsuaaUserInfo.class));
	}

}
