/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.ui;

import com.sap.cds.adapter.IndexContentProvider;
import com.sap.cds.adapter.IndexContentProviderFactory;
import com.sap.cds.framework.spring.config.ui.StaticUiCondition;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class StaticUiIndexContentProviderFactory
implements IndexContentProviderFactory {
    public IndexContentProvider create() {
        return new UiIndexContentProvider(StaticUiCondition.getAppFolder());
    }

    public boolean isEnabled() {
        return StaticUiCondition.hasAppFolder();
    }

    private static class UiIndexContentProvider
    implements IndexContentProvider {
        private static final String ENDPOINT_START = "                <ul>\n";
        private static final String ENDPOINT = "                    <li>\n                        <a href=\"%s\"><span>%s</span></a>\n                    </li>\n";
        private static final String ENDPOINT_END = "                </ul>\n";
        private static final String NONE = "                    <li>\n                        <span> \u2014 none \u2014 </span>\n                    </li>\n";
        private static final Set<String> excludes = Set.of("node_modules", "dist");
        private final List<String> pages = new ArrayList<String>();

        public UiIndexContentProvider(String app) {
            this.findHtmlPages(new File(app), "", 0);
            Collections.sort(this.pages, (p1, p2) -> {
                int s = Integer.compare(UiIndexContentProvider.countSegments(p1), UiIndexContentProvider.countSegments(p2));
                return s == 0 ? p1.compareTo((String)p2) : s;
            });
        }

        private void findHtmlPages(File folder, String prefix, int depth) {
            for (File file : folder.listFiles()) {
                if (file.isFile() && file.getName().endsWith(".html")) {
                    this.pages.add(prefix + file.getName());
                }
                if (depth >= 2 || !file.isDirectory() || excludes.contains(file.getName())) continue;
                this.findHtmlPages(file, prefix + file.getName() + "/", depth + 1);
            }
        }

        private static int countSegments(String path) {
            int count = 0;
            for (char c : path.toCharArray()) {
                if (c != '/') continue;
                ++count;
            }
            return count;
        }

        public String getSectionTitle() {
            return "Web Applications";
        }

        public void writeContent(PrintWriter writer, String contextPath) {
            writer.print(ENDPOINT_START);
            if (this.pages.isEmpty()) {
                writer.print(NONE);
            } else {
                for (String page : this.pages) {
                    writer.printf(ENDPOINT, contextPath + "/" + page, "/" + page.replace("/index.html", ""));
                }
            }
            writer.print(ENDPOINT_END);
        }

        public int order() {
            return -100;
        }
    }
}

