/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth.identity;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.XsuaaUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.ServiceBindingEnvironment;
import com.sap.cloud.security.spring.config.IdentityServiceConfiguration;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class IdentityEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(IdentityEnvironmentPostProcessor.class);
    private static boolean identityLibraryAvailable;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        List xsuaaBindings;
        if (!identityLibraryAvailable) {
            return;
        }
        CdsRuntime runtime = BootstrapCache.get((Environment)environment).getCdsRuntime();
        XsuaaUtils xsuaaUtils = new XsuaaUtils(runtime);
        if (!xsuaaUtils.identityAuthenticationConfigured()) {
            return;
        }
        List identityBindings = xsuaaUtils.getIasServiceBindings();
        if (identityBindings.size() > 1) {
            logger.warn("Multiple service bindings with tag 'identity' found");
        }
        if ((xsuaaBindings = xsuaaUtils.getXsuaaServiceBindings()).size() > 1) {
            logger.warn("Multiple service bindings with tag 'xsuaa' found");
        }
        ArrayList<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
        if (!identityBindings.isEmpty()) {
            bindings.add((ServiceBinding)identityBindings.get(0));
        }
        if (!xsuaaBindings.isEmpty()) {
            bindings.add((ServiceBinding)xsuaaBindings.get(0));
        }
        bindings.forEach(b -> logger.info("Using service binding '{}' to configure identity authentication", b.getName().get()));
        ServiceBindingEnvironment env = new ServiceBindingEnvironment(() -> bindings);
        try {
            Field field = Environments.class.getDeclaredField("currentEnvironment");
            field.setAccessible(true);
            field.set(null, env);
        }
        catch (Exception e) {
            throw new InternalError("Missing field com.sap.cloud.security.config.Environments.currentEnvironment", e);
        }
    }

    static {
        try {
            identityLibraryAvailable = IdentityServiceConfiguration.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            identityLibraryAvailable = false;
        }
    }
}

