/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.datasource;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;

public class DataSourceBeanFactory
implements FactoryBean<DataSource>,
BeanFactoryAware {
    private final String dataSourceName;
    private final Class<?> dataSourceClass;
    private BeanFactory beanFactory;
    private DataSource dataSource;

    public DataSourceBeanFactory(String dataSourceName, Class<?> dataSourceClass) {
        this.dataSourceName = dataSourceName;
        this.dataSourceClass = dataSourceClass;
    }

    public DataSource getObject() throws Exception {
        if (this.dataSource == null) {
            BootstrapCache bootstrapCache = (BootstrapCache)this.beanFactory.getBean(BootstrapCache.class);
            this.dataSource = bootstrapCache.getDataSources().get(this.dataSourceName);
        }
        return this.dataSource;
    }

    public Class<?> getObjectType() {
        return this.dataSourceClass == null ? DataSource.class : this.dataSourceClass;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

