/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.datasource;

import com.sap.cds.framework.spring.config.datasource.SpringTransactionManager;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.changeset.ChangeSetContextSPI;
import com.sap.cds.services.changeset.ChangeSetMember;
import com.sap.cds.services.impl.changeset.ChangeSetContextImpl;
import com.sap.cds.services.transaction.ChangeSetMemberDelegate;
import com.sap.cds.services.transaction.TransactionManager;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@AutoConfiguration
@ConditionalOnClass(value={PlatformTransactionManager.class})
public class PlatformTransactionManagerPostProcessor
implements BeanPostProcessor {
    public static Class<?>[] determineProxyInterfaces(Class<?> clazz) {
        LinkedHashSet interfaces = new LinkedHashSet();
        do {
            interfaces.addAll(Arrays.asList(clazz.getInterfaces()));
        } while (!(clazz = clazz.getSuperclass()).equals(Object.class));
        interfaces.add(SpringTransactionManagerGetter.class);
        return interfaces.toArray(new Class[0]);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Object proxiedBean = bean;
        if (bean instanceof PlatformTransactionManager) {
            PlatformTransactionManager manager = (PlatformTransactionManager)bean;
            Class<?>[] interfaces = PlatformTransactionManagerPostProcessor.determineProxyInterfaces(bean.getClass());
            PTMInvocationHandler handler = new PTMInvocationHandler(manager);
            proxiedBean = Proxy.newProxyInstance(bean.getClass().getClassLoader(), interfaces, (InvocationHandler)handler);
        }
        return proxiedBean;
    }

    public static interface SpringTransactionManagerGetter {
        public SpringTransactionManager getSpringTransactionManager(String var1);

        public PlatformTransactionManager getPlatformTransactionManager();
    }

    private static class PTMInvocationHandler
    implements InvocationHandler {
        private final PlatformTransactionManager platformTxMgr;
        private SpringTransactionManager txMgr;

        public PTMInvocationHandler(PlatformTransactionManager platformTxMgr) {
            this.platformTxMgr = platformTxMgr;
        }

        @Override
        public Object invoke(Object obj, Method method, Object[] args) throws Throwable {
            Object object;
            if (this.txMgr != null && method.getName().equals("getTransaction") && args.length == 1 && (object = args[0]) instanceof TransactionDefinition) {
                TransactionDefinition txDefinition = (TransactionDefinition)object;
                ChangeSetContextSPI currentChangeSet = (ChangeSetContextSPI)ChangeSetContext.getCurrent();
                if (txDefinition.getPropagationBehavior() == 0 && currentChangeSet != null && !currentChangeSet.hasChangeSetMember(this.txMgr.getName())) {
                    currentChangeSet.register((ChangeSetMember)new ChangeSetMemberDelegate((TransactionManager)this.txMgr));
                    this.txMgr.begin(txDefinition);
                } else if (txDefinition.getPropagationBehavior() == 0 && currentChangeSet == null || txDefinition.getPropagationBehavior() == 3) {
                    ChangeSetContextImpl newChangeSetContext = ChangeSetContextImpl.attach();
                    newChangeSetContext.register((ChangeSetMember)new ChangeSetMemberDelegate((TransactionManager)this.txMgr));
                    SpringTransactionSynchronization sync = new SpringTransactionSynchronization(newChangeSetContext);
                    try {
                        TransactionStatus txStatus = (TransactionStatus)method.invoke((Object)this.platformTxMgr, args);
                        sync.setTransactionStatus(txStatus);
                        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)sync);
                        return txStatus;
                    }
                    catch (Exception e) {
                        newChangeSetContext.close();
                        throw e;
                    }
                }
            } else {
                if (method.getName().equals("getSpringTransactionManager") && args.length == 1 && (object = args[0]) instanceof String) {
                    String string = (String)object;
                    if (this.txMgr == null) {
                        this.txMgr = new SpringTransactionManager(string, this.platformTxMgr);
                    }
                    return this.txMgr;
                }
                if (method.getName().equals("getPlatformTransactionManager") && args == null) {
                    return this.platformTxMgr;
                }
            }
            return method.invoke((Object)this.platformTxMgr, args);
        }
    }

    private static class SpringTransactionSynchronization
    implements TransactionSynchronization {
        private final ChangeSetContextImpl changeSetContext;
        private TransactionStatus txStatus;

        public SpringTransactionSynchronization(ChangeSetContextImpl changeSetContext) {
            this.changeSetContext = changeSetContext;
        }

        public void setTransactionStatus(TransactionStatus txStatus) {
            this.txStatus = txStatus;
        }

        public void beforeCompletion() {
            try {
                this.changeSetContext.triggerBeforeClose();
            }
            finally {
                if (this.changeSetContext.isMarkedForCancel() && this.txStatus != null) {
                    this.txStatus.setRollbackOnly();
                }
            }
        }

        public void afterCompletion(int status) {
            if (status != 0) {
                this.changeSetContext.markForCancel();
            }
            this.changeSetContext.close();
        }
    }
}

