package com.sap.cds.framework.spring.actuator;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.info.CdsInfo.Details;

@AutoConfiguration
@ConditionalOnClass(Endpoint.class)
public class CdsActuatorEndpointConfig {

	@Value("#{'${management.endpoint.cds.details:MEDIUM}'.toUpperCase()}")
	private Details defaultDetails;

	@Bean
	public CdsActuatorEndpoint cdsActuatorEndpoint(CdsRuntime runtime) {
		return new CdsActuatorEndpoint(runtime, defaultDetails);
	}

}
