/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.actuator;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.mt.runtime.DbHealthIndicatorImpl;
import com.sap.cloud.mt.runtime.TenantAwareDataSource;

/**
 * A {@link HealthIndicator} for DB availability of a {@link TenantAwareDataSource}.
 */
public class TenantAwareDataSourceHealthIndicator implements HealthIndicator {

	private final DbHealthIndicatorImpl<Health> dbHealthIndicator;

	public TenantAwareDataSourceHealthIndicator(TenantAwareDataSource dataSource, CdsRuntime runtime) {
		long intervallMillis = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getHealthCheck().getInterval().toMillis();
		String healthCheckStatement = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getHealthCheck().getHealthCheckStatement();
		dbHealthIndicator = new DbHealthIndicatorImpl<Health>(healthCheckStatement, dataSource, intervallMillis,
				() -> Health.up().build(),
				(text, details) -> Health.down().withDetail(text, details).build(),
				(text, details) -> Health.up().withDetail(text, details).build());
	}

	@Override
	public Health health() {
		return dbHealthIndicator.health();
	}

}
