/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.adapter;

import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.Controller;

@RestController
@ConditionalOnBean(Servlet.class)
public class ServletAdapterRestController implements Controller {

	private final Servlet servlet;
	private final int beginIndex;

	public ServletAdapterRestController(Servlet servlet, String basePath) {
		this.servlet = servlet;
		this.beginIndex = basePath.length();
	}

	@Override
	public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
		servlet.service(new HttpServletRequestForRestController(request, beginIndex), response);
		return null; // body is set by servlet
	}

	private static class HttpServletRequestForRestController extends HttpServletRequestWrapper {

		private final int beginIndex;

		public HttpServletRequestForRestController(HttpServletRequest request, int beginIndex) {
			super(request);
			this.beginIndex = beginIndex;
		}

		@Override
		public String getPathInfo() {
			String pathInfo = super.getPathInfo();
			if (pathInfo == null) {
				// Spring issue. See
				// https://github.com/spring-projects/spring-framework/issues/21989
				// https://stackoverflow.com/questions/8078364/spring-mvc-controller-getpathinfo-is-null
				pathInfo = super.getServletPath();
			}
			return pathInfo.substring(beginIndex);
		}
	}

}
