/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.framework.spring.config.runtime.CdsRuntimeBeanDefinitionRegistrar;
import com.sap.cds.services.Service;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.environment.ApplicationInfoProvider;
import com.sap.cds.services.environment.ServiceBindingProvider;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.runtime.CdsProvider;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;

@AutoConfiguration(after={CdsRuntimeBeanDefinitionRegistrar.class})
public class CdsRuntimeInitializer
implements InitializingBean,
DisposableBean {
    @Autowired
    private CdsRuntimeConfigurer configurer;
    @Autowired
    private List<Service> services;
    @Autowired(required=false)
    private List<CdsProvider<?>> providers;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private Environment environment;

    public void afterPropertiesSet() throws Exception {
        ServiceCatalog catalog = this.configurer.getCdsRuntime().getServiceCatalog();
        this.services.stream().filter(s -> catalog.getService(s.getName()) == null).forEach(arg_0 -> ((CdsRuntimeConfigurer)this.configurer).service(arg_0));
        this.configurer.eventHandlerConfigurations();
        Arrays.stream(this.context.getBeanNamesForType(EventHandler.class)).filter(name -> !name.startsWith("scopedTarget.")).map(arg_0 -> ((ApplicationContext)this.context).getType(arg_0)).distinct().sorted((Comparator<Class>)AnnotationAwareOrderComparator.INSTANCE).forEach(handlerClass -> this.configurer.eventHandler(handlerClass, () -> this.context.getBean(handlerClass)));
        this.configurer.providerConfigurations();
        if (this.providers != null) {
            CdsRuntimeInitializer.reverse(this.providers.stream()).filter(p -> !ServiceBindingProvider.class.isInstance(p) && !ApplicationInfoProvider.class.isInstance(p)).forEach(p -> this.configurer.provider(p));
        }
        this.configurer.complete();
        BootstrapCache.clear(this.environment);
        this.configurer.getCdsRuntime().requestContext().systemUserProvider().run(req -> catalog.getServices(ApplicationLifecycleService.class).forEach(as -> as.applicationPrepared()));
    }

    public void destroy() throws Exception {
        this.configurer.getCdsRuntime().getServiceCatalog().getServices(ApplicationLifecycleService.class).forEach(as -> as.applicationStopped());
    }

    private static <T> Stream<T> reverse(Stream<T> stream) {
        return stream.collect(Collector.of(() -> new ArrayDeque(), ArrayDeque::addFirst, (q1, q2) -> {
            q2.addAll(q1);
            return q2;
        }, new Collector.Characteristics[0])).stream();
    }
}

