/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.runtime;

import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.annotation.Primary;

import com.sap.cds.framework.spring.config.runtime.RequestContextConfig.RequestContextConfigRuntimeHints;
import com.sap.cds.framework.spring.utils.ProxyUtils;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.request.FeatureTogglesInfo;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;

@AutoConfiguration
@ImportRuntimeHints(RequestContextConfigRuntimeHints.class)
public class RequestContextConfig {

	static class RequestContextConfigRuntimeHints implements RuntimeHintsRegistrar {

		@Override
		public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
			hints.proxies()
				.registerJdkProxy(CdsModel.class)
				.registerJdkProxy(ServiceCatalog.class)
				.registerJdkProxy(UserInfo.class)
				.registerJdkProxy(AuthenticationInfo.class)
				.registerJdkProxy(Messages.class)
				.registerJdkProxy(ParameterInfo.class)
				.registerJdkProxy(FeatureTogglesInfo.class);
		}

	}

	@Bean
	public CdsModel cdsModel(CdsRuntime runtime) {
		return ProxyUtils.createProxy(CdsModel.class, () -> RequestContext.getCurrent(runtime).getModel());
	}

	@Bean
	public ServiceCatalog serviceCatalog(CdsRuntime runtime) {
		return ProxyUtils.createProxy(ServiceCatalog.class, () -> RequestContext.getCurrent(runtime).getServiceCatalog());
	}

	@Bean
	@Primary
	public UserInfo userInfo(CdsRuntime runtime) {
		return ProxyUtils.createProxy(UserInfo.class, () -> RequestContext.getCurrent(runtime).getUserInfo());
	}

	@Bean
	public AuthenticationInfo authenticationInfo(CdsRuntime runtime) {
		return ProxyUtils.createProxy(AuthenticationInfo.class, () -> RequestContext.getCurrent(runtime).getAuthenticationInfo());
	}

	@Bean
	public Messages messages(CdsRuntime runtime) {
		return ProxyUtils.createProxy(Messages.class, () -> RequestContext.getCurrent(runtime).getMessages());
	}

	@Bean
	public ParameterInfo parameterInfo(CdsRuntime runtime) {
		return ProxyUtils.createProxy(ParameterInfo.class, () -> RequestContext.getCurrent(runtime).getParameterInfo());
	}

	@Bean
	public FeatureTogglesInfo featureTogglesInfo(CdsRuntime runtime) {
		return ProxyUtils.createProxy(FeatureTogglesInfo.class,() -> RequestContext.getCurrent(runtime).getFeatureTogglesInfo());
	}

}
