/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.datasource;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.datasource.DataSourceDescriptor;
import com.sap.cds.services.utils.datasource.DataSourceUtils;
import java.util.Arrays;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class DataSourceDescriptorBeanFactory
implements FactoryBean<DataSource>,
EnvironmentAware,
BeanFactoryAware {
    private final String descriptorName;
    private Environment environment;
    private BeanFactory beanFactory;
    private DataSource dataSource;

    public DataSourceDescriptorBeanFactory(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    public DataSource getObject() throws Exception {
        if (this.dataSource == null) {
            BootstrapCache bootstrapCache = (BootstrapCache)this.beanFactory.getBean(BootstrapCache.class);
            DataSourceDescriptor descriptor = bootstrapCache.getDataSourceDescriptors().stream().filter(d -> d.getName().equals(this.descriptorName)).findFirst().orElseThrow(() -> new IllegalStateException());
            DataSourceBuilder builder = DataSourceBuilder.create();
            builder.driverClassName(descriptor.getDriverClassName());
            builder.url(descriptor.getUrl());
            builder.username(descriptor.getUsername());
            builder.password(descriptor.getPassword());
            DataSource ds = builder.build();
            Binder binder = Binder.get((Environment)this.environment);
            Bindable bindableDs = Bindable.ofInstance((Object)ds);
            for (String section : DataSourceDescriptorBeanFactory.getDataSourceSections(descriptor.getName())) {
                BindResult bindResult = binder.bind(section, bindableDs);
                if (!bindResult.isBound()) continue;
                ds = (DataSource)bindResult.get();
                break;
            }
            this.dataSource = ds;
        }
        return this.dataSource;
    }

    private static List<String> getDataSourceSections(String name) {
        return Arrays.asList(DataSourceUtils.getDataSourceSection((String)name, (DataSourceUtils.PoolType)DataSourceUtils.PoolType.HIKARI), DataSourceUtils.getDataSourceSection((String)name, (DataSourceUtils.PoolType)DataSourceUtils.PoolType.TOMCAT), DataSourceUtils.getDataSourceSection((String)name, (DataSourceUtils.PoolType)DataSourceUtils.PoolType.DBCP2));
    }

    public Class<?> getObjectType() {
        return DataSource.class;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

