/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.services.authentication.AuthenticationInfo;
import com.sap.cds.services.authentication.BasicAuthenticationInfo;
import com.sap.cds.services.authentication.JwtTokenAuthenticationInfo;
import com.sap.cds.services.authentication.JwtTokenWithForwardJwtAuthenticationInfo;
import com.sap.cds.services.runtime.AuthenticationInfoProvider;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@AutoConfiguration
@ConditionalOnClass(value={SecurityContextHolder.class})
public class SpringAuthenticationInfoProvider {
    private static final String AUTH_BEARER_PREFIX = "bearer";
    private static final String X_IAS_TOKEN_HEADER = "x-ias-token";

    private static class SecurityContextAuthenticationInfoProvider
    implements AuthenticationInfoProvider {
        private final Function<Authentication, AuthenticationInfo> authenticationMapper;
        private AuthenticationInfoProvider previous;

        public SecurityContextAuthenticationInfoProvider(Function<Authentication, AuthenticationInfo> authenticationMapper) {
            this.authenticationMapper = authenticationMapper;
        }

        public AuthenticationInfo get() {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            AuthenticationInfo authenticationInfo = this.authenticationMapper.apply(authentication);
            return authenticationInfo == null ? this.previous.get() : authenticationInfo;
        }

        public void setPrevious(AuthenticationInfoProvider previous) {
            this.previous = previous;
        }
    }

    @Configuration
    @ConditionalOnClass(value={JwtAuthenticationToken.class})
    public static class OAuth2ResourceServer {
        @Bean
        @Order(value=0x7FFFFFFF)
        public AuthenticationInfoProvider oauth2ResourceServerAuthenticationInfoProvider() {
            return new SecurityContextAuthenticationInfoProvider(auth -> {
                if (auth instanceof JwtAuthenticationToken) {
                    String requestToken = ((Jwt)((JwtAuthenticationToken)auth).getToken()).getTokenValue();
                    String forwardToken = OAuth2ResourceServer.getForwardToken(requestToken);
                    if (forwardToken != null) {
                        return new JwtTokenWithForwardJwtAuthenticationInfo(requestToken, forwardToken);
                    }
                    return new JwtTokenAuthenticationInfo(requestToken);
                }
                return null;
            });
        }

        private static String getForwardToken(String requestToken) {
            String initialToken;
            HttpServletRequest request = null;
            RequestAttributes reqAttrs = RequestContextHolder.getRequestAttributes();
            if (reqAttrs == null || !(reqAttrs instanceof ServletRequestAttributes)) {
                return null;
            }
            request = ((ServletRequestAttributes)reqAttrs).getRequest();
            String authHeader = request.getHeader("Authorization");
            if (authHeader != null && authHeader.toLowerCase(Locale.ENGLISH).startsWith(SpringAuthenticationInfoProvider.AUTH_BEARER_PREFIX) && !(initialToken = authHeader.substring(SpringAuthenticationInfoProvider.AUTH_BEARER_PREFIX.length()).trim()).equals(requestToken)) {
                return initialToken;
            }
            String fwdToken = request.getHeader(SpringAuthenticationInfoProvider.X_IAS_TOKEN_HEADER);
            if (fwdToken != null && !fwdToken.isEmpty()) {
                return fwdToken;
            }
            return null;
        }
    }

    @Configuration
    @ConditionalOnClass(value={OAuth2AuthenticationToken.class})
    public static class OAuth2Client {
        @Bean
        @Order(value=0x7FFFFFFE)
        public AuthenticationInfoProvider oauth2ClientAuthenticationInfoProvider(List<OAuth2AuthorizedClientService> clientServices) {
            return new SecurityContextAuthenticationInfoProvider(auth -> {
                if (auth instanceof OAuth2AuthenticationToken) {
                    String authorizedClientRegistrationId = ((OAuth2AuthenticationToken)auth).getAuthorizedClientRegistrationId();
                    String principalName = ((OAuth2AuthenticationToken)auth).getName();
                    for (OAuth2AuthorizedClientService clientService : clientServices) {
                        OAuth2AuthorizedClient authorizedClient = clientService.loadAuthorizedClient(authorizedClientRegistrationId, principalName);
                        if (authorizedClient == null) continue;
                        return new JwtTokenAuthenticationInfo(authorizedClient.getAccessToken().getTokenValue());
                    }
                }
                return null;
            });
        }
    }

    @Configuration
    @ConditionalOnClass(value={UsernamePasswordAuthenticationToken.class})
    public static class BasicAuth {
        @Bean
        @Order(value=0x7FFFFFFD)
        public AuthenticationInfoProvider basicAuthenticationInfoProvider() {
            return new SecurityContextAuthenticationInfoProvider(auth -> {
                Object principal;
                if (auth instanceof UsernamePasswordAuthenticationToken && (principal = ((UsernamePasswordAuthenticationToken)auth).getPrincipal()) instanceof User) {
                    User user = (User)principal;
                    return new BasicAuthenticationInfo(user.getUsername(), user.getPassword());
                }
                return null;
            });
        }
    }
}

