/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.runtime;

import jakarta.servlet.http.HttpServletRequest;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.ParameterInfoProvider;
import com.sap.cds.services.utils.runtime.HttpParameterInfo;

@AutoConfiguration
@ConditionalOnClass(RequestContextHolder.class) // only if spring-web is available
public class SpringParameterInfoProvider {

	@Bean
	@Order(Ordered.LOWEST_PRECEDENCE)
	public ParameterInfoProvider parameterInfoProvider(CdsRuntime runtime) {
		return new ParameterInfoProvider() {
			@Override
			public ParameterInfo get() {
				RequestAttributes reqAttrs = RequestContextHolder.getRequestAttributes();
				if (reqAttrs != null && reqAttrs instanceof ServletRequestAttributes) {
					HttpServletRequest httpRequest = ((ServletRequestAttributes)reqAttrs).getRequest();
					return HttpParameterInfo.fromRequest(httpRequest, runtime);
				}

				return null;
			}
		};
	}

}
